package assignment2

import (
	"encoding/json"
	"fmt"
	"log"
	"net/http"
	"sort"
	"strconv"
	"time"
)

func HandlerCommits(w http.ResponseWriter, r *http.Request) {

	var I []IDS
	var C Commits

	URL1 := "https://git.gvk.idi.ntnu.no/api/v4/projects"                // main link
	URL2 := "https://git.gvk.idi.ntnu.no/api/v4/projects?private_token=" // main ling with auth
	Client := http.DefaultClient

	URL3 := URL1 + "?per_page=100" // adds max limit of repositories per page

	auth := QueryGet("auth", "false", r) // gets auth from localhost link
	if auth != "false" {                 // check if auth not false
		URL3 = URL2 + auth + "&per_page=100" // change link to work with auth
		C.Auth = true                        // sets auth to true
	}

	fmt.Println(URL3) // **************************************************

	resp, err := DoRequest(Client, w, URL3) //request the /prodjects link with 100 repositoris per page
	if err != nil {
		http.Error(w, err.Error(), http.StatusBadRequest)
		return
	}

	PageTot, err := strconv.Atoi(resp.Header.Get("X-Total-Pages")) //Get the total of pages that have repositoris
	if err != nil {                                                //check for error
		log.Fatal(err)
	}
	fmt.Println(PageTot)

	for i := 1; i <= PageTot; i++ { // loop true all pages
		URL4 := URL3 + "&page=" + strconv.Itoa(i) // adds page numer to link
		resp, err := DoRequest(Client, w, URL4)   // request link
		if err != nil {
			http.Error(w, err.Error(), http.StatusBadRequest)
			return
		}

		var TempID []IDS // makes a temp for IDS

		err = json.NewDecoder(resp.Body).Decode(&TempID) // decode to temp
		if err != nil {                                  //check for error
			http.Error(w, err.Error(), http.StatusBadRequest)
			return
		}
		fmt.Println("str Temp: ", len(TempID)) // *****************************************************************

		I = append(I, TempID...) // adds temp to I

		fmt.Println("str i: ", len(I)) // **********************************************

		var TempRep Commits // creates temp for commits

		resp, err = DoRequest(Client, w, URL4) // request link
		if err != nil {
			http.Error(w, err.Error(), http.StatusBadRequest)
			return
		}

		err = json.NewDecoder(resp.Body).Decode(&TempRep.Repos) // decode to temp
		if err != nil {                                         //check for error
			http.Error(w, err.Error(), http.StatusBadRequest)
			return
		}

		C.Repos = append(C.Repos, TempRep.Repos...) // adds temp to C.Repos, so that C.Repos gets a length

		fmt.Println("str c: ", len(C.Repos)) // ********************************************************

	}

	for i := range I { // loops true length of I
		URL := URL1 + "/" + strconv.Itoa(I[i].ID) + "/repository/commits" // creats link to get commits for id
		if auth != "false" {                                              // check if auth is true
			URL = URL + "?private_token=" + auth // adds token to link for auth
		}

		resp, err := DoRequest(Client, w, URL) // request link
		if err != nil {
			http.Error(w, err.Error(), http.StatusBadRequest)
			return
		}

		TempCommit, err := strconv.Atoi(resp.Header.Get("X-Total")) // gets total of commits
		if err != nil {                                             //check for error
			fmt.Println("Repository do not exist, ID: ", I[i].ID)
			TempCommit = 0 // if repository do not exist, sets commit to 0
		}

		C.Repos[i].Commits = TempCommit // sets commits count in to C.Repos

		C.Repos[i].Repository = I[i].Name // sets name for repository inn to C.Repos

	}

	// order the C.Repos slice so that the repositor with highest commits comse out on top and so on
	sort.Slice(C.Repos, func(i, j int) bool { return C.Repos[i].Commits > C.Repos[j].Commits })

	limit := QueryGet("limit", "5", r) // gets limit for localhost link

	TempInt, err := strconv.Atoi(limit) // convert limit string to an int
	if err != nil {                     //check for error
		log.Fatal(err)
	}

	C.Repos = C.Repos[:TempInt] // sets how many repositories are gonna get displayed

	http.Header.Add(w.Header(), "Content-Type", "application/json") // makes the print look good

	// Webhooks**********************

	Payload := &WebhooksInvocation{}
	Payload.Event = "Commits"
	Payload.Time = time.Now()
	Payload.Params = "Limit = " + limit + "and Auth = " + auth

	json.NewEncoder(w).Encode(C) // encode C

}
