package assignment2

import (
	"fmt"
	"log"

	"golang.org/x/net/context"

	firebase "firebase.google.com/go" // Same as python's import dependency as alias.

	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
)

var fb = FireBase{}

func FBInit() {
	// Firebase initialisation
	fb.Ctx = context.Background()
	// We use a service account, load credentials file that you downloaded from your project's settings menu.
	// Make sure this file is gitignored, it is the access token to the database.
	sa := option.WithCredentialsFile("./cloud-assignment2-fc85f-firebase-adminsdk-14mld-d42cb80420.json")
	app, err := firebase.NewApp(fb.Ctx, nil, sa)
	if err != nil {
		log.Fatalln(err)
	}

	fb.Client, err = app.Firestore(fb.Ctx)

	// Alternative setup, directly through Firestore
	// client, err := firestore.NewClient(ctx, projectID)

	if err != nil {
		log.Fatalln(err)
	}

}

func FBClose() {
	fb.Client.Close()
}

func FBSave() {

	ref := fb.Client.Collection("Webhooks").NewDoc()
	webhook.ID = ref.ID
	_, err := ref.Set(fb.Ctx, webhook)
	if err != nil {
		fmt.Println("ERROR saving webhook to Firestore DB: ", err)
		//return errors.Wrap(err, "Error in FirebaseDatabase.Save()")
	}
	// return nil
}

func FBRead() {
	iter := fb.Client.Collection("Webhooks").Documents(fb.Ctx)
	for {
		doc, err := iter.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			log.Fatalf("Failed to iterate: %v", err)
		}
		fmt.Println(doc.Data())
		doc.DataTo(&webhook)
		tempCount := 0
		for i := range webhooks {
			if webhooks[i].ID == webhook.ID {
				tempCount++
			}
		}

		if tempCount == 0 {
			webhooks = append(webhooks, webhook)
		}

	}
}
