package assignment2

import (
	"bytes"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"strconv"
	"strings"
	"time"
)

var webhooks []WebhookRegistration //Webhook DB
var IDNum = 1

/*
	Handles webhook registration (POST) and lookup (GET) requests.
	Expects WebhookRegistration struct body in request.
*/
var webhook = WebhookRegistration{}

func WebhookHandeler(w http.ResponseWriter, r *http.Request) {

	switch r.Method {
	case http.MethodPost:

		err := json.NewDecoder(r.Body).Decode(&webhook)
		if err != nil {
			http.Error(w, err.Error(), http.StatusBadRequest)
		}

		webhook.Time = time.Now()
		IDNum++

		FBSave()
		webhooks = append(webhooks, webhook)

		fmt.Fprintln(w, len(webhooks)-1)
		fmt.Println("Webhooks " + webhook.URL + " has been regstrerd")

	case http.MethodGet:
		FBRead()
		http.Header.Add(w.Header(), "Content-Type", "application/json") // makes the print look good
		parts := strings.Split(r.URL.Path, "/")                         //finds url parts
		fmt.Println(parts)
		if len(parts) == 5 {

			tempInt, err := strconv.Atoi(parts[4])
			if err != nil {
				http.Error(w, err.Error(), http.StatusBadRequest)
			}

			err = json.NewEncoder(w).Encode(webhooks[tempInt-1])
			if err != nil {
				http.Error(w, "Some thing went wrong"+err.Error(), http.StatusInternalServerError)
			}
		} else {
			err := json.NewEncoder(w).Encode(webhooks)
			if err != nil {
				http.Error(w, "Some thing went wrong"+err.Error(), http.StatusInternalServerError)
			}
		}

	default:
		http.Error(w, "Method is invalid "+r.Method, http.StatusBadRequest)
	}

}

/*
	Invokes the web service to trigger event. Currently only responds to POST requests.
*/

func ServiceHandler(w http.ResponseWriter, r *http.Request) {

	switch r.Method {
	case http.MethodPost:
		fmt.Println("Recive POST request")
		for _, v := range webhooks {
			go CallUrl(v.URL, "Resonse on registered event in webhook demo: "+v.Event)
		}
	default:
		http.Error(w, "Method is invalid "+r.Method, http.StatusBadRequest)
	}
}

/*
	Calls given URL with given content and awaits response (status and body).
*/

func CallUrl(url string, content string) {
	fmt.Println("Attempting invocation of url " + url + "...")
	res, err := http.Post(url, "string", bytes.NewReader([]byte(content)))
	if err != nil {
		fmt.Println("Error in HTTP request: " + err.Error())
	}

	response, err := ioutil.ReadAll(res.Body)
	if err != nil {
		fmt.Println("Something is wrong with invocation response: " + err.Error())
	}

	fmt.Println("Webhook invoked. Received status code " + strconv.Itoa(res.StatusCode) +
		" and body: " + string(response))

}
