package assignment2

import (
	"fmt"
	"log"

	"github.com/pkg/errors"
	"golang.org/x/net/context"

	firebase "firebase.google.com/go" // Same as python's import dependency as alias.

	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
)

var fb = FireBase{}

func FBInit() error {
	// Firebase initialisation
	fb.Ctx = context.Background()
	// We use a service account, load credentials file that you downloaded from your project's settings menu.
	// Make sure this file is gitignored, it is the access token to the database.
	sa := option.WithCredentialsFile("./cloud-assignment2-fc85f-firebase-adminsdk-14mld-d42cb80420.json")
	app, err := firebase.NewApp(fb.Ctx, nil, sa)
	if err != nil {
		fmt.Printf("Error in FirebaseDatabase.Init() function: %v\n", err)
		return errors.Wrap(err, "Error in FirebaseDatabase.Init()")

	}

	fb.Client, err = app.Firestore(fb.Ctx)

	// Alternative setup, directly through Firestore
	// client, err := firestore.NewClient(ctx, projectID)

	if err != nil {
		log.Fatalln(err)
	}

	return nil

}

func FBClose() {
	fb.Client.Close()
}

func FBSave() error {

	ref := fb.Client.Collection("Webhooks").NewDoc()
	webhook.ID = ref.ID
	_, err := ref.Set(fb.Ctx, webhook)
	if err != nil {
		fmt.Println("ERROR saving webhook to Firestore DB: ", err)
		return errors.Wrap(err, "Error in FirebaseDatabase.Save()")
	}
	return nil
}

func FBRead() ([]WebhookRegistration, error) {

	var Temp []WebhookRegistration
	iter := fb.Client.Collection("Webhooks").Documents(fb.Ctx)
	for {
		doc, err := iter.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			log.Fatalf("Failed to iterate: %v", err)
		}
		//fmt.Println(doc.Data())
		err = doc.DataTo(&webhook) // sets data in to webhook struct
		if err != nil {
			fmt.Println("Error when converting retrieved document to webhook struct: ", err)
		}

		Temp = append(Temp, webhook)

	}
	return Temp, nil
}

func FBDelete(ID string) error {
	docRef := fb.Client.Collection("Webhooks").Doc(ID)
	_, err := docRef.Delete(fb.Ctx)
	if err != nil {
		fmt.Printf("ERROR deleting webhook (%v) from Firestore DB: %v\n", err)
		return errors.Wrap(err, "Error in FirebaseDatabase.Delete()")
	}
	return nil
}
