package assignment2

import (
	"encoding/json"
	"fmt"
	"log"
	"net/http"
	"sort"
	"strconv"
	"time"
)

func Counter(S []string) map[string]int {

	count := make(map[string]int)
	for _, Lang := range S {
		_, ok := count[Lang]
		if ok {
			count[Lang] += 1
		} else {
			count[Lang] = 1
		}
	}
	return count
}

func HandlerLanguages(w http.ResponseWriter, r *http.Request) {

	var I []IDLang
	var L Language
	var Code []string

	URL1 := "https://git.gvk.idi.ntnu.no/api/v4/projects"                // main url
	URL2 := "https://git.gvk.idi.ntnu.no/api/v4/projects?private_token=" // url for token
	Client := http.DefaultClient

	URL3 := URL1 + "?per_page=100"

	auth := QueryGet("auth", "false", r) // gets auth from localhost link
	if auth != "false" {                 // check ig auth is not false
		L.Auth = true // sets auth to true
		URL3 = URL2 + auth + "&per_page=100"

	}

	fmt.Println(URL3)

	resp, err := DoRequest(Client, w, URL3) // request link
	if err != nil {
		http.Error(w, err.Error(), http.StatusBadRequest)
		return
	}

	PageTot, err := strconv.Atoi(resp.Header.Get("X-Total-Pages")) // gets count of total pages
	if err != nil {                                                // check for error
		http.Error(w, err.Error(), http.StatusBadRequest)
		return
	}
	//fmt.Println(PageTot) // ***************************************************************

	for i := 1; i <= PageTot; i++ { // loops true total pages
		URL := URL3 + "&page=" + strconv.Itoa(i) // sets url to one page

		resp, err := DoRequest(Client, w, URL)
		if err != nil {
			http.Error(w, err.Error(), http.StatusBadRequest)
			return
		}

		var TempID []IDLang //creat temp for id

		err = json.NewDecoder(resp.Body).Decode(&TempID) // decode to I
		if err != nil {                                  // check for error
			http.Error(w, err.Error(), http.StatusBadRequest)
			return
		}

		I = append(I, TempID...) // adds test to I

		//fmt.Println("len: ", len(I))

	}

	for i := range I { // loops true length of I
		URL := URL1 + "/" + strconv.Itoa(I[i].ID) + "/languages" // creats url for languages with id
		if auth != "false" {
			URL = URL + "?private_token=" + auth // adds token to link
		}

		// fmt.Println(URL) //****************************************************************

		var CodeTemp = make(map[string]interface{})

		resp, err = DoRequest(Client, w, URL) // request link
		if err != nil {
			http.Error(w, err.Error(), http.StatusBadRequest)
			return
		}

		err = json.NewDecoder(resp.Body).Decode(&CodeTemp) // decode to language
		if err != nil {                                    // check for error
			http.Error(w, err.Error(), http.StatusBadRequest)
			return
		}

		for j := range CodeTemp {
			Code = append(Code, j)
		}

	}

	var Lang []TestLang // making a temp struckt

	CodeTypes := Counter(Code) // make a map[string]int that have codelanguag counted
	//fmt.Println("test: ", CodeTypes) //*********************************************

	for k, v := range CodeTypes { // loops over map
		Lang = append(Lang, TestLang{k, v}) // sets map values in to struct
	}

	sort.Slice(Lang, func(i, j int) bool { return Lang[i].Count > Lang[j].Count }) //sort struct from highest to lovest int

	//fmt.Println(Lang) //****************************************************************

	for i := range Lang { // loops over struct
		L.Languages = append(L.Languages, Lang[i].Lang) // sets string from struct inn to L.Languages
	}

	limit := QueryGet("limit", "5", r) // gets limit for localhost link

	TempInt, err := strconv.Atoi(limit) // turns sting to int
	if err != nil {                     //  check for error
		log.Fatal(err)
	}

	L.Languages = L.Languages[:TempInt] // sets how many lauguages gets posted

	http.Header.Add(w.Header(), "Content-Type", "application/json") // makes the print look good
	json.NewEncoder(w).Encode(L)                                    // encode L

	// Webhooks**********************

	CallUrl("languages", "Limit = "+limit+" and Auth = "+auth, time.Now())

}
