package assignment2

import (
	"encoding/json"
	"net/http"
	"time"
)

func HandlerStatus(w http.ResponseWriter, r *http.Request) {
	var S Status

	resp, err := http.Get("https://git.gvk.idi.ntnu.no")
	if err != nil {
		http.Error(w, err.Error(), http.StatusBadRequest)
		return
	}

	S.Gitlab = resp.StatusCode

	resp, err = http.Get("https://firebase.google.com") //må endre link
	if err != nil {
		http.Error(w, err.Error(), http.StatusBadRequest)
		return
	}

	S.Database = resp.StatusCode

	elapse := time.Since(StartTime)
	S.Uptime = elapse.Seconds()

	S.Version = "v1"

	http.Header.Add(w.Header(), "Content-Type", "application/json") // makes the print look good

	json.NewEncoder(w).Encode(S)
}
