package assignment2

import (
	"time"

	"cloud.google.com/go/firestore"
	"golang.org/x/net/context"
)

//************* Commits ******************

type IDS struct {
	Name string `json:"path_with_namespace"`
	ID   int    `json:"id"`
}

type Temp struct {
	TempInt int `json:"x-Total"`
}

type RepoAndCommit struct {
	Repository string `json:"repository"`
	Commits    int    `json:"commits"`
}

type Commits struct {
	Repos []RepoAndCommit
	Auth  bool `json:"auth"`
}

// *********** Language ************

type IDLang struct {
	ID int `json:"id"`
}

type TestLang struct {
	Lang  string
	Count int
}

type Language struct {
	Languages []string `json:"lagnguages"`
	Auth      bool     `json:"auth"`
}

// *********** Status ************
type Status struct {
	Gitlab   int     `json:"gitlab"`
	Database int     `json:"database"`
	Uptime   float64 `json:"uptime"`
	Version  string  `json:"version"`
}

//************ Webhook ************

type WebhookRegistration struct {
	ID    string    `json:"id"`
	Event string    `json:"event"`
	URL   string    `json:"url"`
	Time  time.Time `json:"time"`
}

// type Webhooks struct {
// 	ID    int     `json:"id"`
// 	Event string  `json:"Event"`
// 	URL   string  `json:"url"`
// 	Time  float64 `json:"time"`
// }

type WebhooksInvocation struct {
	Event  string `json:"event"`
	Params string `json:"params"`
	Time   string `json:"time"`
}

//************ Firebase ***********
type FireBase struct {
	Ctx    context.Context
	Client *firestore.Client
}
