package assignment2

import (
	"bytes"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"strings"
	"time"
)

var webhook = WebhookRegistration{}

/*
	Handles webhook registration (POST) and lookup (GET) requests.
	Expects WebhookRegistration struct body in request.
*/

func WebhookHandeler(w http.ResponseWriter, r *http.Request) {

	switch r.Method {
	case http.MethodPost:

		err := json.NewDecoder(r.Body).Decode(&webhook) //decode to webhook
		if err != nil {
			http.Error(w, err.Error(), http.StatusBadRequest)
		}

		webhook.Event = strings.ToLower(webhook.Event)
		webhook.Time = time.Now() // sets time stamp

		err = FBSave() // saves webhook to firebase
		if err != nil {
			fmt.Println("Error: ", err)
		}

		fmt.Println("Webhooks " + webhook.URL + " has been regstrerd")

	case http.MethodGet:
		var webhooks []WebhookRegistration //Webhook DB
		webhooks, err := FBRead()
		if err != nil {
			fmt.Println("Error: ", err)
		}
		http.Header.Add(w.Header(), "Content-Type", "application/json") // makes the print look good

		err = json.NewEncoder(w).Encode(webhooks) // encode all webhooks
		if err != nil {
			http.Error(w, "Some thing went wrong"+err.Error(), http.StatusInternalServerError)
		}

	case http.MethodDelete:

		err := json.NewDecoder(r.Body).Decode(&webhook) //decode to webhook
		if err != nil {
			http.Error(w, err.Error(), http.StatusBadRequest)
		}

		err = FBDelete(webhook.ID)
		if err != nil {
			fmt.Println("Error: ", err)
		}

	default:
		http.Error(w, "Method is invalid "+r.Method, http.StatusBadRequest)
	}

}

func WebhookHandeler2(w http.ResponseWriter, r *http.Request) {
	switch r.Method {

	case http.MethodGet:
		var webhooks []WebhookRegistration //Webhook DB
		webhooks, err := FBRead()
		if err != nil {
			fmt.Println("Error: ", err)
		}
		http.Header.Add(w.Header(), "Content-Type", "application/json")

		parts := strings.Split(r.URL.Path, "/") //finds url parts
		fmt.Println(parts)

		for i := range webhooks {
			if webhooks[i].ID == parts[4] {
				err = json.NewEncoder(w).Encode(webhooks[i]) // encode choosen webhook
				if err != nil {
					http.Error(w, "Some thing went wrong"+err.Error(), http.StatusInternalServerError)
				}

			}
		}

	default:
		http.Error(w, "Method is invalid "+r.Method, http.StatusBadRequest)

	}

}

/*
	Calls given URL with given content and awaits response (status and body).
*/

func CallUrl(event string, params string, timestamp time.Time) {
	var webhooks []WebhookRegistration
	webhooks, err := FBRead()
	if err != nil {
		fmt.Println("Error: ", err)
	}

	for i := range webhooks {
		if webhooks[i].Event == event {
			var request = WebhooksInvocation{Event: event, Params: params, Time: timestamp.String()}

			requestBody, err := json.Marshal(request)
			if err != nil {
				fmt.Println("Can not encode: " + err.Error())
			}

			fmt.Println("Attempting invoation of URL " + webhooks[i].URL + "...")

			resp, err := http.Post(webhooks[i].URL, "json", bytes.NewReader([]byte(requestBody)))
			if err != nil {
				fmt.Println("Error in HTTP request: " + err.Error())
			}

			response, err := ioutil.ReadAll(resp.Body)
			if err != nil {
				fmt.Println("Something vent wrong: " + err.Error())
			}

			fmt.Println("Webhook body: " + string(response))

		}

	}

}
