package main

import (
	"assignment2"
	"fmt"
	"log"
	"net/http"
	"os"
	"time"
)

var StartTime = time.Now() // sets StartTime

func main() {
	assignment2.StartTime = StartTime // sends StartTime

	assignment2.FBInit()
	//assignment2.FBSave()
	//assignment2.FBRead()
	defer assignment2.FBClose()

	port := os.Getenv("PORT")
	if port == "" {
		port = "8080"
	}

	http.HandleFunc("/", assignment2.HandlerNil)
	http.HandleFunc("/repocheck/v1/commits", assignment2.HandlerCommits)     // runs handelr function
	http.HandleFunc("/repocheck/v1/languages", assignment2.HandlerLanguages) // runs handelr function
	http.HandleFunc("/repocheck/v1/status", assignment2.HandlerStatus)       // runs handelr function
	http.HandleFunc("/repocheck/v1/webhooks", assignment2.WebhookHandeler)   // runs handelr function
	fmt.Println("Listening on port " + port)
	log.Fatal(http.ListenAndServe(":"+port, nil))
}
