package assignment2

import (
	"fmt"
	"net/http"
	"time"
)

var StartTime time.Time

func HandlerNil(w http.ResponseWriter, r *http.Request) { //standar default respons
	fmt.Println("Default Handler: Invalid request received.")
	http.Error(w, "Invalid request", http.StatusBadRequest)
}

func QueryGet(s string, t string, r *http.Request) string { // funk to read limit and auth

	test := r.URL.Query().Get(s) // gets limit or auth for localhost link
	if test == "" {              // check if it is empty
		test = t // give it a default value if empty
	}
	return test

}

func DoRequest(Client *http.Client, w http.ResponseWriter, API string) (*http.Response, error) { // Request api
	req, err := http.NewRequest(http.MethodGet, API, nil)
	if err != nil {
		http.Error(w, err.Error(), http.StatusBadRequest)

	}

	resp, err := Client.Do(req)
	if err != nil {
		http.Error(w, err.Error(), http.StatusBadRequest)
	}

	return resp, err
}

// func HandlerWebhooks(w http.ResponseWriter, r *http.Request) {

// }
