import cv2
import numpy as np

def viewImage(image):
    cv2.namedWindow('Display', cv2.WINDOW_NORMAL)
    cv2.imshow('Display', image)
    cv2.waitKey(0)
    cv2.destroyAllWindows()
    
def findGreatesContour(contours, imsize):
    largest_area = 0
    largest_contour_index = -1

    i = 0
    total_contours = len(contours)
    while (i < total_contours ):
        area = cv2.contourArea(contours[i])
        if(area > largest_area and area < imsize*0.9):
            largest_area = area
            largest_contour_index = i

        i+=1
            
    return largest_area, largest_contour_index

def create_mask(im):
    gray = cv2.cvtColor(im, cv2.COLOR_RGB2GRAY)

    ret, threshold = cv2.threshold(gray, np.mean(gray)/1.5, 255, cv2.THRESH_BINARY+cv2.THRESH_OTSU)
    viewImage(threshold) 

    i, contours, hierarchy=  cv2.findContours(threshold,cv2.RETR_TREE,cv2.CHAIN_APPROX_SIMPLE)



    largest_area, largest_contour_index = findGreatesContour(contours, gray.size)

    cv2.drawContours(im, contours[largest_contour_index], -1, (0, 0, 255), 3)

    mask = np.zeros(im.shape)
    cv2.fillPoly(mask, pts =[contours[largest_contour_index]], color=(255,255,255))
    
    return mask 
    

