const smartcrop = require('smartcrop-sharp');
const sharp = require('sharp');
const glob = require('glob')
const util = require('util');
const path = require('path');
const args = process.argv.slice(2);
const fs = require('fs');

const inputFolder = args[0];
const outputFolder = args[1];

const promiseGlob = util.promisify(glob);

async function cropFiles() {
	const targetWidth = 512;
	const targetHeight = 512;

	const originalWidth = 1240;
	const originalHeight = 1748;

	const files = await promiseGlob(`${inputFolder}/*.jpg`);

	const crops = [];

	for(const image of files) {
		const smartCropOptions = {
			ruleOfThirds: false,
		};

		const row = await smartcrop.crop(image, {
			width: originalWidth,
			height: targetHeight,
			...smartCropOptions,
		});

		const column = await smartcrop.crop(image, {
			width: targetWidth,
			height: originalHeight,
			...smartCropOptions,
		})

		imageCrop = {
			filename: path.basename(image),
			x: column.topCrop.x,
			y: row.topCrop.y,
			width: targetWidth,
			height: targetWidth,
		};

		await sharp(image)
			.extract({
				left: imageCrop.x,
				top: imageCrop.y,
				width: targetWidth,
				height: targetHeight,
			})
			.toFile(path.join(outputFolder, imageCrop.filename.slice(0, -4) + '.png'))

		crops.push(imageCrop);
	}

	fs.writeFileSync(`${outputFolder}/crops.json`, JSON.stringify(crops));
}

cropFiles();
