from cv2 import cv2
import os

from algorithm.main_src.SalamanderImage import SalamanderImage

#import skeletonization
#import straightening
import algorithm.main_src.dsift as dsift
import algorithm.main_src.segmentation as segmentation

def create_salamander_image(filename: str):
	print("Processing image " + filename)
	salamander_image = SalamanderImage(filename)
	
	salamander_image.filename = filename
	salamander_image.descriptors = get_descriptors(filename)

	return salamander_image

def get_descriptors(filename: str):
	image = get_straightened_image(filename)
	return calculate_descriptors(image)

"""
Reads, straightens, resizes the image and returns it as a
"""
def get_straightened_image(filename: str):
	#TODO: Fiks filnavn format
	straightened_filename = filename#[0:-4] + '_str.jpg'
	image = get_image(straightened_filename)
	
	return image

"""
Should return a binary image (numpy ndarray) with 1 for "Part of salamander"
and 0 for "Not part of the salamander".
"""
def get_segmented_image(filename: str):
	image = get_image(filename)
	return segmentation.get_salamander_mask(image)
	
def get_image(filename):
	image = cv2.imread(filename, cv2.IMREAD_GRAYSCALE)

	if image is None:
		raise FileNotFoundError("Cannot find image file " + filename)
	
	return image

"""
Calculates descriptors from preprocessed image
"""
def calculate_descriptors(image):
	return dsift.compute_descriptors(image)
