import database
import imageprocessing
import cv2 as cv2
import glob
import database
import shutil
import os
from Salamander import Salamander
from constants import input_salamander_id, input_images_path,images_basepath
from imageprocessing import create_salamander_image
from matching import match_image
from database import salamanders

def main():
	answer =  input ("Load new input images (y/n)?")

	while answer == 'y': 
		salamanders = database.load()
		salamander = Salamander(input_salamander_id)
		salamander.images = [create_salamander_image(file) for file in glob.iglob(input_images_path + '/*[!=_str and !=_th].jpg')]
		if len(salamander.images) == 0 :
			print ('No images in input folder, try again!')
			return None
		# print(salamander)
		print("Matching image " + salamander.images[0].filename + " against " + str(len(salamanders)) + " individuals")
		input_salamander = match_image(salamander.images)
		if input_salamander is None:
			print("No match for image " + salamander.images[0].filename + " could found.")
			new_id = input ("Enter a new salamander id: ")
			id = int(new_id)
			#id_exist = salamanders.get(id)
			#if id_exist is not None:
			new_salamander = Salamander(id)
			salamanders.update({ id: new_salamander})
			new_salamander.images = salamander.images
			os.mkdir(images_basepath + str(id))
			for file in glob.iglob(input_images_path + '/*.jpg'):
				shutil.move(file, images_basepath + str(id))
			#if id_exist is None:
				#print ("ID already exists!")
				#return None

		if input_salamander is not None:
			id_exist = salamanders.get(input_salamander.id)
			print("Adding image of salamander " + str(input_salamander.id) + " to database")
			if id_exist is not None:
				for image in salamander.images:
					input_salamander.images.append(image)
			for file in glob.iglob(input_images_path + '/*.jpg'):
				shutil.move(file, images_basepath + input_salamander.id)
			salamanders.update({input_salamander.id: input_salamander})
			
		del salamander
		database.save(salamanders)
		answer =  input ("Load new input images (y/n)?")

if __name__ == "__main__":
	main()