from cv2 import cv2
from Salamander import Salamander
from SalamanderImage import SalamanderImage
from database import salamanders, load
from imageprocessing import create_salamander_image
from constants import min_good_match
from constants import match_dist
def match_image(salamander_image: SalamanderImage) -> Salamander:
	salamanders = load()
	bf = cv2.BFMatcher()
	matches = []
	good = []
	salamander_match = []
	# print (salamanders)
	for id in salamanders:
		salamander = salamanders[id]
		# print('Matching with ', id)
		for image in salamander.images:
			for input_image in salamander_image:
				match = bf.knnMatch(input_image.descriptors, image.descriptors, k=2)
				matches.append(match)
			for match in matches:
				goodmatch = []
				for m, n in match:
					if m.distance < match_dist * n.distance:
						goodmatch.append([m])
				good.append([goodmatch])

			is_same_image = input_image.filename == image.filename
			if is_same_image:
				del input_image
			is_match = len(goodmatch) > min_good_match and not is_same_image
			if is_match: 
				print('Match found :', salamander.id)
				return salamander
	return None

def num_of_good_matches(match):
	salamander, good_matches = match 

	return good_matches
