import os

from cv2 import cv2
# from SalamanderImage import SalamanderImage
# from database import salamanders, load
from algorithm.main_src.imageprocessing import create_salamander_image

min_good_match = 15
match_dist = 0.75


# def match_image(input_image: SalamanderImage) -> Salamander:
# TODO: Load fra den nye databasen

# salamanders = load()  Må laste inn file path laget i APIen
# bf = cv2.BFMatcher()
# matches = []
# good = []
# # print (salamanders)
# for id in salamanders:
#     salamander = salamanders[id]
#     # print('Matching with ', id)
#     for image in salamander.images:
#         match = bf.knnMatch(input_image.descriptors, image.descriptors, k=2)
#         matches.append(match)
#         for match in matches:
#             goodmatch = []
#             for m, n in match:
#                 if m.distance < match_dist * n.distance:
#                     goodmatch.append([m])
#             good.append([goodmatch])
#
#         is_same_image = input_image.filename == image.filename  #Burde ha bedre sjekk enn bare filnavn
#         if is_same_image:
#             del input_image
#         is_match = len(goodmatch) > min_good_match and not is_same_image
#         if is_match:
#             print('Match found :', salamander.id)
#             return salamander
# return None


def match_single_image(input_image, match_image) -> bool:
    bf = cv2.BFMatcher()
    input_salamander = create_salamander_image(input_image)
    match_salamander = create_salamander_image(match_image)

    match = bf.knnMatch(input_salamander.descriptors, match_salamander.descriptors, k=2)

    goodmatch = []
    for m, n in match:
        if m.distance < match_dist * n.distance:
            goodmatch.append([m])
    # print(len(goodmatch))
    if len(goodmatch) > min_good_match:
        return True
    return False


def match_file_structure(input_image, match_directory) -> int:
    for folder in os.listdir(match_directory):
        current_dir = match_directory + folder
        for filename in os.listdir(current_dir):
            if filename.endswith("_str.png"):
                match_image = current_dir + "/" + filename
                res = match_single_image(input_image, match_image)
                if res:
                    return int(folder)
    return -1


# print(match_file_structure("..\\..\\img_analyze\\img81_str.png", "..\\..\\Male"))
# res = match_single_image("..\\..\\img_analyze\\img40Edit_str.png", "..\\..\\img_analyze\\img43_str.png")
