from cv2 import cv2
import numpy as np
import csv

def get_deeplabcut_data(path):
	with open(path + 'videoDeepCut_resnet50_lizard-idMay10shuffle1_350000.csv', mode='r') as estimated_images:
		image_data_reader = csv.reader(estimated_images)
		
		results = []

		i = 0
		for pose in image_data_reader:
			if i > 2:
				points = np.array([
					[pose[1], pose[2]],
					[pose[4], pose[5]],
					[pose[7], pose[8]],
					[pose[10], pose[11]],
					[pose[13], pose[14]],
				]).astype(float)

				img = cv2.imread('data/test-images/img' + str(i - 3) + '.png')

				results.append((points, img))
			
			i += 1
		
		return results

def get_leap_data(path):
	with open(path + 'positions.csv') as lines:
		line_reader = csv.reader(lines)

		i = 0
		lines = []
		for cur_line in line_reader:
			lines.append(cur_line)

		results = []

		for i in range(len(lines)):
			line = lines[i]
			if i % 2 == 0:
				nextline = lines[i+1]
				points = np.array([
					[nextline[0], line[0]],
					[nextline[1], line[1]],
					[nextline[2], line[2]],
					[nextline[3], line[3]],
					[nextline[4], line[4]],
				]).astype(int) * 2
				
				img = cv2.imread('data/test-images/img' + str(int(i/2)) + '.png')

				results.append((points, img))
	
		return results

def get_manual_data(path):
	with open(path + 'manual.csv', mode='r') as labeled_images:
		image_data_reader = csv.reader(labeled_images)
		
		results = []

		i = 0
		for pose in image_data_reader:
			if i == 0:
				pose[0] = pose[0][3:]
			points = np.array([
				[pose[0], pose[1]],
				[pose[2], pose[3]],
				[pose[4], pose[5]],
				[pose[6], pose[7]],
				[pose[8], pose[9]],
			]).astype(float)

			img = cv2.imread('data/test-images/img' + str(i) + '.png')

			results.append((points, img))
			
			i += 1

		return results