import h5py
from cv2 import cv2
import glob
from imageprocessing import get_image
import numpy as np
import smartcrop
from PIL import Image

def write_h5():
	f = h5py.File('data/salamanders-test.h5', mode='w')

	image_files = [file for file in glob.iglob('data/test-images2/*.png')]

	f.create_dataset('box', (len(image_files), 1, 256, 256), np.uint8)

	for i in range(len(image_files)):
		file = image_files[i]
		resized = get_resized_image(file)
		f['box'][i, 0, :, :] = resized[None]

	f.close()

	return

def get_resized_image(filename):
	image = get_image(filename)

	return cv2.resize(image, (256, 256), interpolation=cv2.INTER_CUBIC)


if __name__ == "__main__":
	write_h5()
