import cv2
import numpy as np
import glob
import os
from imageprocessing import create_salamander_image
import database
from Salamander import Salamander
from constants import images_basepath

def import_images():
  images_foldername = [os.path.basename(os.path.dirname(file)) for file in glob.iglob(images_basepath + '*/*[_str].jpg')]
  images_id = [x for i, x in enumerate(images_foldername) if i == images_foldername.index(x)]
  for salamanderid in images_id:
    print(salamanderid)
    salamander = Salamander(salamanderid)
    database.salamanders.update({ salamanderid: salamander})
    salamander.images = [create_salamander_image(file) for file in glob.iglob(images_basepath + salamanderid + '/*[!=_str and !=_th].jpg')]

if __name__ == "__main__":
	import_images()
	database.save(database.salamanders)
