import csv
import os
import sys
from shutil import copyfile

def restructure():
	imagedir = sys.argv[1]

	with open('data/scandetail.csv', mode='r') as csv_file:
		csv_reader = csv.DictReader(csv_file)
		line_count = 0
		for row in csv_reader:
			print(f'ID:{row["ID"]}')
			filename = row["picturename"][12:]
			oldpath = os.path.join(imagedir, "newpictures")
			newpath = os.path.join(imagedir, "images", row["imageheadid"])
			print(f'Moving from {oldpath} to {newpath}')

			if not os.path.exists(newpath):
				os.makedirs(newpath)
			
			copyfile(os.path.join(oldpath, filename), os.path.join(newpath, filename))

			line_count += 1
		print(f'Processed {line_count} items')

if __name__ == "__main__":
	restructure()
