from cv2 import cv2
import numpy as np
import csv
from straightening import get_smooth_curve
from posedatareader import get_deeplabcut_data
from posedatareader import get_leap_data
from posedatareader import get_manual_data

def main():
	visualize_leap()
	visualize_deeplabcut()
	visualize_manual()

def visualize_deeplabcut():
	deeplabcut_path = 'data/deeplabcut-results/'
	data = get_deeplabcut_data(deeplabcut_path)
	visualize(data, deeplabcut_path)

def visualize_leap():
	leap_path = 'data/leap-results/'
	data = get_leap_data(leap_path)
	visualize(data, leap_path)

def visualize_manual():
	manual_path = 'data/manually-labeled/'
	data = get_manual_data(manual_path)
	visualize(data, manual_path)

def visualize(results, path):
	colors = [
		(66, 134, 244),
		(66, 244, 235),
		(66, 244, 75),
		(244, 229, 66),
		(244, 86, 66)
	]

	i = 0
	for (points, img) in results:
		rounded_points = points.round().astype(int)

		curve = get_smooth_curve(points, 500)

		for curve_point in curve:
			rounded_point = curve_point.round().astype(int)
			point = tuple(rounded_point)

			cv2.rectangle(img, point, point, color=(255, 0, 0), thickness=2)

		for j in range(5):
			point = tuple(rounded_points[j])
			cv2.circle(img, point, radius=4, color=colors[j], thickness=-1)
		
		cv2.imwrite(path + 'line_visualization_000' + str(i) + '.png', img)

		i += 1

if __name__ == "__main__":
	main()
