from cv2 import cv2
import numpy as np

def get_salamander_mask(image):
	ret, threshold = cv2.threshold(image, np.mean(image)-40, 255, 0)

	i, contours, hierarchy = cv2.findContours(threshold, cv2.RETR_TREE, cv2.CHAIN_APPROX_SIMPLE)

	largest_area, largest_contour_index = find_biggest_contour(contours, image.size)

	cv2.drawContours(image, contours[largest_contour_index], -1, (0, 0, 255), 3)

	mask = np.zeros(image.shape)

	cv2.fillPoly(mask, pts =[contours[largest_contour_index]], color=(255,255,255))
	
	return mask

def find_biggest_contour(contours, imsize):
	largest_area = 0
	largest_contour_index = -1

	i = 0
	total_contours = len(contours)
	while (i < total_contours ):
		area = cv2.contourArea(contours[i])
		if(area > largest_area and area < imsize*0.9):
			largest_area = area
			largest_contour_index = i

		i+=1
			
	return largest_area, largest_contour_index
