import cv2
from skimage.morphology import skeletonize
from skimage import data
import numpy as np
import sknw
import networkx as nx

def get_belly_line(image):
	graph = get_graph(image)

	belly_line = get_belly_line_from_graph(graph)

	return belly_line

"""
Takes in a skeleton graph and returns the belly line.
"""
def get_belly_line_from_graph(graph):
	belly = get_edge_max_weight(graph, ignore_edge_nodes=True)

	return belly['pts']

"""
Takes in grayscale or binary image. 2-d array of numbers between 1 and 0.
"""
def get_graph(image):
	image = np.where(image > 0.5, 1, 0)

	# Perform skeletonization
	skeleton = skeletonize(image)

	graph = sknw.build_sknw(skeleton)

	# Contracts nodes that are close together to get only the main parts of the skeleton.
	graph = contract_close_nodes(graph)

	return graph

def get_edge_min_weight(graph, weight, only_edge_nodes=False):
	for u in graph.nodes():
		neighbors = graph.neighbors(u)
		num_of_neighbors = len(list(neighbors))
		if (not only_edge_nodes) or (num_of_neighbors == 1):
			for v in graph[u]:
				edge = graph.edges[u, v]
				if edge['weight'] < weight:
					return (v, u)

def get_edge_max_weight(graph, ignore_edge_nodes=False):
	max_weight = 0
	max_edge = None
	for u in graph.nodes():
		for v in graph[u]:
			edge = graph.edges[u, v]
			both_edge_nodes = is_edge_node(graph, u) and is_edge_node(graph, v)
			if (not ignore_edge_nodes or both_edge_nodes) and edge['weight'] > max_weight:
				max_weight = edge['weight']
				max_edge = edge
	
	return max_edge

def is_edge_node(graph, u):
	neighbors = graph.neighbors(u)
	num_of_neighbors = len(list(neighbors))
	return num_of_neighbors > 1

def contract_close_nodes(graph):
	while(get_edge_min_weight(graph, 5)):
		edge = get_edge_min_weight(graph, 5)
		graph = nx.contracted_edge(graph, edge, self_loops=False)

	contract_treshold = 100

	while(get_edge_min_weight(graph, contract_treshold, only_edge_nodes=True)):
		edge = get_edge_min_weight(graph, contract_treshold, only_edge_nodes=True)
		graph = nx.contracted_edge(graph, edge, self_loops=False)
	
	return graph
