from skimage import io
import matplotlib.pyplot as plt
import numpy as np

from constants import images_basepath
import imageprocessing
from skeletonization import get_graph
from skeletonization import get_belly_line_from_graph

def test_skeletonization():
	filename = images_basepath + '120/Cam1.20130415.215711.avi.0000.jpg'

	original_image = imageprocessing.get_image(filename)
	segmented_image = imageprocessing.get_segmented_image(filename)

	plt.imshow(original_image)
	plt.imshow(segmented_image, alpha=0.2)
	plt.axis('off')

	graph = get_graph(segmented_image)
	belly_line = get_belly_line_from_graph(graph)

	# Plot nodes as red dots
	node, nodes = graph.node, graph.nodes()
	filtered_nodes = list(filter(lambda x: 'o' in nodes[x], nodes))
	ps = np.array([node[i]['o'] for i in filtered_nodes])
	plt.plot(ps[:,1], ps[:,0], 'r.')


	# Plot normal edges as green lines
	for (s,e) in graph.edges():
		ps = graph[s][e]['pts']
		plt.plot(ps[:,1], ps[:,0], 'green')
	
	# Plot belly line in blue
	plt.plot(belly_line[:,1], belly_line[:,0], 'blue')

	plt.show()

if __name__ == '__main__':
	test_skeletonization()
