import numpy as np
from cv2 import cv2
import straightening
from constants import height
import imageprocessing
import csv
from posedatareader import get_deeplabcut_data
from posedatareader import get_leap_data

def test_curve():
	points = np.array([
		[574, 546],
		[652, 649],
		[677, 770],
		[665, 935],
	])

	img = cv2.imread('./images/150/Cam1.20130415.221324.avi.0000.jpg')

	straight_image = straightening.straighten(img, points)
	cv2.imshow("Straightened salamander", straight_image)
	cv2.waitKey()


def test_straight_line():
	img = cv2.imread('./images/63/Cam1.20130415.213244.avi.0000.jpg')
	t = np.linspace(0, 1, height).reshape((height, 1))
	
	start = np.array([1080, 428])
	diff = np.array([-600, 1110])
	line = start + diff * t

	straight_image = straightening.straighten(img, line)

	cv2.imshow("Straightened salamander", straight_image)
	cv2.waitKey()

def test_skeletonized():
	image = imageprocessing.get_straightened_image('images/120/Cam1.20130415.215711.avi.0000.jpg')
	
	cv2.imshow('image', image)
	cv2.waitKey(0)
	cv2.destroyAllWindows()

def test_deeplabcut():
	path = 'data/deeplabcut-results/'
	results = get_deeplabcut_data(path)
	test_with_results(results, path)

def test_leap():
	
	path = 'data/leap-results/'
	results = get_leap_data(path)
	test_with_results(results, path)

def test_with_results(results, base_path):
	for i in range(len(results)):
		(points, img) = results[i]
		straight_image = straightening.straighten(img, points)

		cv2.imwrite(base_path + 'image_000' + str(i) + '_str.png', straight_image)

if __name__ == '__main__':
	test_curve()
