import new_straightening as straighten
# CROPPING IMAGE
import cv2
import os
import matplotlib.pyplot as plt

config_path= "dlc_model/config.yaml"
directory_path= "../../../salamander-api/img_analyze"
image_to_predict = "female.png"

config =  os.path.abspath(config_path)
os_directory_path =  os.path.abspath(directory_path)
image_type = image_to_predict[-4:]
img_directory = os_directory_path + '\\' + image_to_predict
smallpath = os_directory_path + '/' + 'small' + image_to_predict

# reading image:
img = cv2.imread(img_directory)
# You will have to convert the color if you use OpenCV.
img = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)


str_image, img, points, shoulder_points, _ = straighten.straighten(image = img)
if str_image is not None:
    str_image = cv2.cvtColor(str_image, cv2.COLOR_BGR2RGB)
    cv2.imwrite(directory_path + '/' + image_to_predict[0:-4] + '_str.png', str_image)
    # data points
    implot = plt.imshow(img)
    print(points[0])
    # put a blue dot at (10, 20)
    plt.scatter(points[0][0], points[0][1], c='b', s=40, )
    plt.scatter(points[1][0], points[1][1], c='r', s=40, )
    plt.scatter(points[2][0], points[2][1], c='g', s=40, )
    plt.scatter(points[3][0], points[3][1], c='y', s=40, )
    plt.scatter(shoulder_points[0][0], shoulder_points[0][1], c='y', s=40, )
    plt.scatter(shoulder_points[1][0], shoulder_points[1][1], c='y', s=40, )

    plt.savefig(directory_path + '/' + image_to_predict[0:-4] + '_points.png')