from flask import Flask
from flask_restful import Api
from flask_bcrypt import Bcrypt
from flask_jwt_extended import JWTManager
from flask_sqlalchemy import SQLAlchemy


app = Flask(__name__)
app.config['SECRET_KEY'] = 'randomchangethisshit'
app.config['SQLALCHEMY_DATABASE_URI'] = 'sqlite:///database/database.db'
app.config['JWT_AUTH_USERNAME_KEY'] = 'email'
app.config['JWT_ACCESS_TOKEN_EXPIRES'] = 5 * 3600
db = SQLAlchemy(app)
jwt = JWTManager(app)
bcrypt = Bcrypt(app)
api = Api(app)


from api.endpoints.login import Login
from api.endpoints.user import UserEndpoint
from api.endpoints.location import LocationEndpoint
from api.endpoints.verifypassword import VerifyPassword
from api.endpoints.matchsalamander import MatchSalamander
from api.endpoints.findsalamanderinfo import FindSalamanderInfo


api.add_resource(Login, "/login")
api.add_resource(UserEndpoint, "/user")
api.add_resource(LocationEndpoint, "/location")
api.add_resource(VerifyPassword, "/verifyPassword")
api.add_resource(MatchSalamander, "/matchSalamander")
api.add_resource(FindSalamanderInfo, "/findSalamanderInfo")
