from flask import request, jsonify
from flask_restful import Resource
from flask_jwt_extended import get_jwt_identity, jwt_required
from algorithm.train_src.new_straightening import straighten
import cv2
import os

ALLOWED_EXTENSIONS = ['jpeg', 'png', 'jpg']


# findSalamanderInfo endpoint
class FindSalamanderInfo(Resource):
    @staticmethod
    @jwt_required
    def post():
        if "image" not in request.files:
            return jsonify({"message": "no file given"})
        image = request.files['image']
        user_id = get_jwt_identity()
        if image.filename != '':
            if image and allowed_image(image.filename):
                image.filename = str(user_id) + "." + extension(image.filename)
                image.save("temp_images/" + image.filename)
                execution_path = os.path.abspath(os.getcwd())
                img = cv2.imread(execution_path + "/temp_images/" + str(user_id) + "." + extension(image.filename), 1)
                # run AI on image
                str_image, _, _, _, _ = straighten(img)
                if str_image is not None:
                    cv2.imwrite("temp_images/" + str(user_id) + "_str.png", str_image)
                    return jsonify({"sex": "AI_sex", "species": "AI_species"})

                else:
                    return jsonify({"message": "image could not be processed"})
            else:
                return jsonify({"message": "file extension not allowed"})
        else:
            return jsonify({"message": "something wrong with image"})


def allowed_image(filename):
    return '.' in filename and \
           filename.rsplit('.', 1)[1].lower() in ALLOWED_EXTENSIONS


def extension(filename):
    return filename.rsplit('.', 1)[1].lower()
