from flask import request, jsonify
from flask_restful import Resource
from flask_jwt_extended import jwt_required
from api import db
from api.models.dbmodels import Location
import re
import os

LATITUDE_REGEX = "^(\\+|-)?(?:90(?:(?:\\.0{1,6})?)|(?:[0-9]|[1-8][0-9])(?:(?:\\.[0-9]{1,6})?))$"
LONGITUDE_REGEX = "^(\\+|-)?(?:180(?:(?:\\.0{1,6})?)|(?:[0-9]|[1-9][0-9]|1[0-7][0-9])(?:(?:\\.[0-9]{1,6})?))$"


# findSalamanderInfo endpoint
class LocationEndpoint(Resource):
    @staticmethod
    @jwt_required
    def post():
        data = request.form
        if "name" in data and "radius" in data and "latitude" in data and "longitude" in data:
            location = db.session.query(Location).filter_by(name=data['name'].lower()).first()
            if location is None and re.search(LATITUDE_REGEX, data['latitude']) and re.search(LONGITUDE_REGEX, data['longitude']):
                new_location = Location(name=data['name'].lower(), longitude=data['longitude'],
                                        latitude=data['latitude'], radius=data['radius'])
                db.session.add(new_location)
                db.session.commit()
                create_directory_folders(data['name'].lower())
                return jsonify({"message": "new location registered"})
            else:
                return jsonify({"message": "this location name already in use or bad coordinates"})
        else:
            return jsonify({"message": "wrong data"})

    @staticmethod
    @jwt_required
    def get():
        locations = db.session.query(Location).all()
        location_list = []
        for location in locations:
            loc = {"id": location.id, "radius": location.radius, "name": location.name, "latitude": location.latitude, "longitude": location.longitude}
            location_list.append(loc)
        return jsonify(location_list)


def create_directory_folders(location):
    dir_smooth_male = "images/" + location + "/smooth_newt/" + "male/"
    dir_smooth_female = "images/" + location + "/smooth_newt/" + "female/"
    dir_smooth_juvenile = "images/" + location + "/smooth_newt/" + "juvenile/"
    dir_northern_male = "images/" + location + "/northern_crested_newt/" + "male/"
    dir_northern_female = "images/" + location + "/northern_crested_newt/" + "female/"
    dir_northern_juvenile = "images/" + location + "/northern_crested_newt/" + "juvenile/"
    os.makedirs(dir_smooth_male)
    os.makedirs(dir_smooth_female)
    os.makedirs(dir_smooth_juvenile)
    os.makedirs(dir_northern_male)
    os.makedirs(dir_northern_female)
    os.makedirs(dir_northern_juvenile)
