from flask import request, jsonify
from flask_jwt_extended import create_access_token
from flask_restful import Resource
from api.models.dbmodels import User
from api import bcrypt, db


class Login(Resource):
    @staticmethod
    def post():
        data = request.form
        if data['email'] or data['password']:
            user = db.session.query(User).filter_by(email=data['email'].lower()).first()
            if user and bcrypt.check_password_hash(user.pwd, data['password']):
                if user.accepted:
                    ret = {
                        'access_token': create_access_token(identity=user.id),
                        'message': "successfully logged in",
                        'admin': user.admin,
                        'name': user.name,
                        'email': user.email
                    }
                    return jsonify(ret)
                else:
                    return jsonify({'message': 'not accepted by admin'})
            else:
                return jsonify({'message': 'login failed, wrong email or password'})
        else:
            return jsonify({"message": "data provided was incorrect"})
