from flask import request, jsonify, send_file
from flask_restful import Resource
from flask_jwt_extended import jwt_required, get_jwt_identity
import os.path
import shutil
from api import db
from api.models.dbmodels import Location
from api.models.dbmodels import Salamander, SalamanderGrowth
from algorithm.main_src.new_matching import match_file_structure

APPROVED_SEX = ["male", "female", "juvenile"]
APPROVED_SPECIES = ["smooth_newt", "northern_crested_newt"]


# matchSalamander endpoint
class MatchSalamander(Resource):
    @staticmethod
    @jwt_required
    def post():
        data = request.form
        user_id = get_jwt_identity()
        locations = db.session.query(Location.name).all()
        approved_locations = []
        for location in locations:
            approved_locations.append(location.name)

        if "sex" in data and "location" in data and "species" in data and "confirmed" in data:
            if data['sex'] in APPROVED_SEX and data['species'] in APPROVED_SPECIES and data['location'].lower() in approved_locations:
                if data['confirmed']:
                    path_to_processed_image = "./temp_images/" + str(user_id) + "_str.png"
                    path_to_original_image = "./temp_images/" + str(user_id) + ".png"
                    path_to_images = "./images/" + data['location'].lower() + "/" + data['species'] + "/" + data['sex'] + "/"
                    if data['sex'] != "juvenile":
                        result = match_file_structure(path_to_processed_image, path_to_images)
                        if result > -1:
                            if "weight" in data and "length" in data:
                                salamander_growth = SalamanderGrowth(salamander_id=result, weight=data['weight'], length=data['length'])
                                db.session.add(salamander_growth)
                                db.session.commit()
                            move_and_rename_images(path_to_images + str(result) + "/", path_to_original_image, path_to_processed_image)
                            return jsonify({"message": "MATCH!", "id": result})
                        else:
                            salamander_id = add_salamander(data, path_to_images, user_id, path_to_original_image, path_to_processed_image)
                            return jsonify({"message": "new salamander in database", "id": salamander_id})
                    else:
                        salamander_id = add_salamander(data, path_to_images, user_id, path_to_original_image, path_to_processed_image)
                        return jsonify({"message": "new juvenile in database", "id": salamander_id})

                else:
                    return jsonify({"message": "image was not accepted"})
            else:
                return jsonify({"message": "invalid sex, species or location"})
        else:
            return jsonify({"message": "errors in form data"})

    @staticmethod
    @jwt_required
    def get():
        user_id = get_jwt_identity()
        return send_file("../temp_images/" + str(user_id) + "_str.png", attachment_filename=str(user_id) + ".png")


def add_salamander(data, path_to_images, user_id, path_to_original_image, path_to_processed_image):
    location_id = db.session.query(Location.id).filter_by(name=data['location'].lower()).first()
    new_salamander = Salamander(sex=data['sex'], species=data['species'], location_id=location_id[0], uid=user_id)
    db.session.add(new_salamander)
    db.session.commit()
    salamander_id = db.session.query(Salamander.id).filter_by(uid=user_id).order_by(Salamander.id.desc()).first()
    path_for_new_salamander = path_to_images + str(salamander_id[0]) + "/"
    os.makedirs(path_for_new_salamander)
    move_and_rename_images(path_for_new_salamander, path_to_original_image, path_to_processed_image)
    return salamander_id[0]


def move_and_rename_images(path_to_salamander, path_to_original_image, path_to_processed_image):
    number_of_files = len(os.listdir(path_to_salamander)) / 2
    shutil.move(path_to_original_image, path_to_salamander + str(number_of_files) + ".png")
    shutil.move(path_to_processed_image, path_to_salamander + str(number_of_files) + "_str.png")
