from flask import request, jsonify
from flask_jwt_extended import jwt_required, get_jwt_identity
from flask_restful import Resource
from api import db
import os
from api.models.dbmodels import Location, Salamander


class DeleteSalamander(Resource):
    @staticmethod
    @jwt_required
    def post():
        data = request.form
        if "location" in data:
            location = db.session.query(Location).filter_by(name=data['location'].lower()).first()
            if location is not None:
                salamanders = db.session.query(Salamander).all()
                salamander_list = []
                for salamander in salamanders:
                    ret = {"id": salamander.id, "sex": salamander.sex, "species": salamander.species, "location": location.name}
                    salamander_list.append(ret)
                return jsonify(salamander_list)
            else:
                return jsonify({"message": "this location does not exist"})
        else:
            return jsonify({"message": "data provided was incorrect"})

    @staticmethod
    @jwt_required
    def delete():
        data = request.form
        if "id" in data and "location" in data:
            user_id = get_jwt_identity()
            salamander = db.session.query(Salamander).filter_by(id=data['id']).first()
            if salamander.uid == user_id:
                salamander_path = "images/" + data['location'] + "/" + salamander.species + "/" + salamander.sex + "/" + salamander.id
                os.remove(salamander_path)
                db.session.delete(salamander)
                db.session.commit()
                return jsonify({"id": salamander.id, "message": "salamander deleted"})
            else:
                return jsonify({"message": "this user cannot delete this salamander"})
        else:
            return jsonify({"message": "wrong data in form"})

