from flask import request, jsonify
from flask_restful import Resource
from api.models.dbmodels import User
from api import bcrypt, db
import re
from flask_jwt_extended import get_jwt_identity, jwt_required

EMAIL_REGEX = "^[a-z0-9]+[\._]?[a-z0-9]+[@]\w+[.]\w{2,3}$"


class UserEndpoint(Resource):
    @staticmethod
    def post():
        data = request.form
        if 'name' in data and 'email' in data and 'password' in data and 'confirmPassword' in data:
            if data['password'] == data['confirmPassword']:
                user = db.session.query(User).filter_by(email=data['email'].lower()).first()
                if not user and re.search(EMAIL_REGEX, data['email'].lower()):
                    password_hash = bcrypt.generate_password_hash(data['password'])
                    new_user = User(name=data['name'].lower(), email=data['email'].lower(), pwd=password_hash)
                    db.session.add(new_user)
                    db.session.commit()
                    output = {"message": "new user created"}
                else:
                    output = {"message": "invalid email"}
            else:
                output = {"message": "password does not match"}
        else:
            output = {"message": "wrong data posted"}
        return output

    @staticmethod
    @jwt_required
    def delete():
        data = request.form
        user_id = get_jwt_identity()
        if 'email' in data and 'password' in data:
            user = db.session.query(User).filter_by(email=data['email']).first()
            if user and bcrypt.check_password_hash(user.pwd, data['password']) and user_id == user.id:
                db.session.delete(user)
                db.session.commit()
                return jsonify({"message": "user deleted"})
            else:
                return jsonify({"message": "email or password not matching"})
        else:
            return jsonify({"message": "wrong data sent"})

    @staticmethod
    @jwt_required
    def put():
        data = request.form
        user_id = get_jwt_identity()
        user = db.session.query(User).filter_by(id=user_id).first()
        if user is not None:
            if 'newName' in data:
                user.name = data['newName']

            if 'newEmail' in data:
                if re.search(EMAIL_REGEX, data['newEmail'].lower()):
                    user.email = data['newEmail']

            db.session.commit()
        return jsonify({"message": "user was updated"})


