from flask import request, jsonify
from flask_restful import Resource
from api import bcrypt, db
from flask_jwt_extended import get_jwt_identity, jwt_required
from api.models.dbmodels import User


class VerifyPassword(Resource):
    @staticmethod
    @jwt_required
    def post():
        data = request.form
        if "password" in data:
            user_id = get_jwt_identity()
            user = db.session.query(User).filter_by(id=user_id).first()
            if user is not None:
                if user.id == user_id:
                    if bcrypt.check_password_hash(user.pwd, data['password']):
                        return jsonify({"verified": True})
                    else:
                        return jsonify({"verified": False})
                else:
                    return jsonify({"verified": False})
            else:
                return jsonify({"verified": False})
        else:
            return jsonify({"verified": False})
