﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;

[System.Serializable]
public class CityGenWindow : EditorWindow
{
	[System.NonSerialized]
	private string saveFolder;
	[System.NonSerialized]
	private string filename = "editor.json";
	[System.NonSerialized]
	private bool citySelectionMenuEnabled = true;
	[System.NonSerialized]
	private Vector2 citySelectionMenuScrollPosition;

	public List<string> entries = new List<string>();

	CityGen cityGen = new CityGen();

	public void OnGUI()
	{
		MakeMainCityMenu();
	}

// ######### GUI Functions #########

	// Make Main menu for selecting the city to edit.
	private void MakeMainCityMenu()
	{
		string cityName = "Name here!";
		this.citySelectionMenuScrollPosition = GUILayout.BeginScrollView(this.citySelectionMenuScrollPosition, GUILayout.Width(100), GUILayout.Height(100));
			foreach(string str in this.entries)
				if (GUILayout.Button(str))
					HandleMainCityMenuEvent(str);
			EditorGUILayout.Separator();
			EditorGUILayout.BeginHorizontal("Button");
				cityName = GUILayout.TextField(cityName);
				if (GUILayout.Button("Add"))
					NewCity(cityName);
			EditorGUILayout.EndHorizontal();

		GUILayout.EndScrollView();
	}

	private void NewCity(string cityname_filename)
	{
		entries.Add(cityname_filename);
		//cityGen.NewCity();
	}

	private bool HandleMainCityMenuEvent(string cityname_filename)
	{
		if (!cityGen.load(cityname_filename))
		{
			Debug.Log("Couldn't find file for: " + cityname_filename);
			return false;
		}
		return true;	
	}

// ######### Window Event Funtions #########

	private void OnEnable()
	{
		saveFolder = Application.persistentDataPath + "/CityData/";

		// Not first launch, editor file exists
		if (System.IO.File.Exists(this.saveFolder + this.filename))
			load();
	}

	public void OnDestroy()
	{
		save();
	}

// ######### Save + Load #########

	// Save the data about city.
	void save () 
	{
		// Wrap the list for jason conversion
		CityEntryListWrapper<string> list = new CityEntryListWrapper<string>(this.entries);
		// Covert city object to json.
		string stringDataAsJson = JsonUtility.ToJson(list);
		// Creates a directory in local disk.
		System.IO.Directory.CreateDirectory(this.saveFolder);
		// Write all the data to a file.
		System.IO.File.WriteAllText(this.saveFolder + this.filename, stringDataAsJson);
	}

	// Load the data about city.
	void load()
	{
		// Read from file.
		string cityDataAsJson = System.IO.File.ReadAllText(this.saveFolder + this.filename);
		// Dump result in wrapper object.
		CityEntryListWrapper<string> obj = JsonUtility.FromJson<CityEntryListWrapper<string>>(cityDataAsJson);
		// Transfer data.
		this.entries = obj.list;
	}

// ######### Show CityGen in Window Tab #########
	// Menu entry
	[MenuItem ("Window/City Gen")]
	public static void ShowWindow()
    {
        //Show existing window instance. If one doesn't exist, make one.
        EditorWindow.GetWindow<CityGenWindow>("City Gen");
    }
}

// ######### Container Classes #########

// ######### Wrapper Classes #########
[System.Serializable]
public class CityEntryListWrapper<T>
{
	public List<T> list = new List<T>();

	public CityEntryListWrapper()
	{
		//
	}

	public CityEntryListWrapper(List<T> list)
	{
		this.list = list;
	}
}