package com.example.kent.myfirstapplication;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.CountDownTimer;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.Toast;

public class A1 extends AppCompatActivity
{
    SharedPreferences sharedPref;
    SharedPreferences.Editor sharedPrefEditor;
    boolean pressedBack = false;
    CountDownTimer cdt = new CountDownTimer(1500, 1)
    {
        @Override
        public void onTick(long millisUntilFinished)
        {
        }

        @Override
        public void onFinish()
        {
            setPressedBack(false);
        }
    };

    // Make spinner widget in public scope
    Spinner spinner;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_a1);

        // Get all widgets
        final SeekBar seekBar = findViewById(R.id.a1_seekBar01);
        spinner = findViewById(R.id.a1_spinner01);
        final Button btn = findViewById(R.id.a1_button01);

        // Add click listener and send intent to "A2" once clicked
        btn.setOnClickListener(new View.OnClickListener()
        {
            public void onClick(View view)
            {
                Intent intent = new Intent(getApplicationContext(), A2.class);
                EditText editText = findViewById(R.id.a1_editText01);
                intent.putExtra("name", editText.getText().toString());
                startActivity(intent);
            }
        });

        // Set button text using resources xml file
        btn.setText(R.string.a1_btn_text);

        // Setup shared preferences
        this.sharedPref = getPreferences(Context.MODE_PRIVATE);
        this.sharedPrefEditor = this.sharedPref.edit();

        // Fill spinner with items from resources file
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(this, R.array.spinnerItems, R.layout.support_simple_spinner_dropdown_item);
        adapter.setDropDownViewResource(R.layout.support_simple_spinner_dropdown_item);
        spinner.setAdapter(adapter);

        // Set selection if available, defaults to 0
        spinner.setSelection(this.sharedPref.getInt(getResources().getString(R.string.sharedPref_data_spinner), 0));

    }

    @Override
    public void onBackPressed()
    {
        // First press of back button
        if (!isPressedBack())
        {
            // Tell user to repeat if he/she want's to exit
            Toast.makeText(getApplicationContext(), "Press back again to quit!", Toast.LENGTH_SHORT).show();

            // Start count down timer to reset action if user doesn't press again
            this.cdt.start();
            setPressedBack(true);

        } else    // Second press, user wants to exit
        {
            // Exit
            this.cdt.cancel();
            super.onBackPressed();
        }
    }

    @Override
    protected void onStop()
    {
        // Save spinner selection and stop
        this.sharedPrefEditor.putInt(getString(R.string.sharedPref_data_spinner), spinner.getSelectedItemPosition());
        this.sharedPrefEditor.commit();
        super.onStop();
    }

    public boolean isPressedBack()
    {
        return pressedBack;
    }

    public void setPressedBack(boolean pressedBack)
    {
        this.pressedBack = pressedBack;
    }
}
