# Expecting two lists of several pairs representing the start and end of each interval.
# EXAMPLE: 
#   Observed: [ (3, 4), (5, 9), (6, 11) ]
#   True: [ (2, 4), (5, 10), (10, 12) ]
def calculateSuccess(observedIntervalsList, trueIntervalsList):
    # List of success rates / similarity indices per observed interval.
    indices = []
    for obsInt in observedIntervalsList:

        # Calculates the similarity index by considering the index of each observed interval with respect to how many true intervals are overlapping it.
        # This means they are initially overweighted (producing indices that are too low), which is fixed by multiplying by the count of overlaps.
        obsIntIndex = 0
        overlappingTrueInts = 0
        for i in range(len(trueIntervalsList)):

            # Checks if true interval overlaps with observed. No bias in direction, meaning observed interval too low has same error as too high.
            # Can be changed by adding more if statements based on the condition, so that having observed intervals too high is punished less than too low.
            if not (obsInt[0] > trueIntervalsList[i][1] or obsInt[1] < trueIntervalsList[i][0]):
                overlappingTrueInts += 1

                intersection = min(obsInt[1], trueIntervalsList[i][1]) - max(obsInt[0], trueIntervalsList[i][0])
                union = max(obsInt[1], trueIntervalsList[i][1]) - min(obsInt[0], trueIntervalsList[i][0])

                obsIntIndex += intersection / union
        if overlappingTrueInts > 0:
            obsIntIndex *= overlappingTrueInts
        indices.append(obsIntIndex)

    # Pads with zeroes if there is an excess of true intervals that do not overlap with any observed intervals.
    while len(indices) < len(trueIntervalsList):
        indices.append(0)
    print(indices)

def main():
    test = ((101, 167), (480, 520), (700, 710))
    real = ((70, 180), (300,400), (500, 510), (705, 720))
    calculateSuccess(test, real)

if __name__ == "__main__":
    main()

