from moviepy.editor import VideoFileClip
from moviepy.video.compositing.CompositeVideoClip import CompositeVideoClip
from os import listdir
from time import sleep
import os
import csv
import logging
import sys
import ffmpeg

# Logger for logging purposes (seeing which file is currently being processed)
logFormat = "%(levelname)s %(asctime)s - %(message)s"

logging.basicConfig(stream = sys.stdout, 
                    filemode = "w",
                    format = logFormat, 
                    level = logging.INFO)


#   Trims input video file according to interval of timestamps given in CSV.
#   Uses ffmpeg-python, which builds a command-line call to ffmpeg that trims parts and finally concatenates them.
#   Does NOT delete input video file yet.
def trim(inputVideo, csvTimestamps):
    paddingSecs = 1
    movieClip = VideoFileClip(inputVideo)
    trims = []

    # Pads intervals with an extra second, and checks for edge cases.
    for timestampNo in range(0, len(csvTimestamps)-1, 2):
        startTime = int(csvTimestamps[timestampNo]) - paddingSecs
        endTime = int(csvTimestamps[timestampNo+1]) + paddingSecs
        if startTime < 0:
            startTime = 0
        if endTime > movieClip.duration:
            endTime = movieClip.duration
        
        # Trims the source video for each interval. 'setpts' filter is used so timestamps are handled correctly; without it,
        #       still frames will appear in the final video, as it trims based on closest keyframes and fills the gap with stills.
        trims.append(ffmpeg.input(inputVideo).trim(start=startTime, end=endTime).filter('setpts', expr='PTS-STARTPTS'))
    (
        ffmpeg
        .concat(*trims)
        .filter('setpts', expr='PTS-STARTPTS')
        .output("trimmed/%s" % inputVideo)
        .run(quiet=False)
    )
        

def main():
    # Changes working directory to the specified path. CHANGE DURING STANDALONE BUILD.
    os.chdir("gitlab repo/nina-thesis")
    if "trimmed" not in os.listdir():
        os.mkdir("trimmed")

    while(True):    
        for file in os.listdir():
            if file.endswith(".csv"):
                with open(file) as csvFile:
                    reader = csv.reader(csvFile, delimiter=",")
                    for row in reader:
                        logging.getLogger().info("Trimming file %s" % row[0])
                        trim(row[0], row[1:])
        sleep(900)


if __name__ == "__main__":
    main()
