from dataclasses import dataclass
import pandas as pd
import ERFormatConstants as const
from dynamics import *


class Threat: 
    """_summary_ 
    The class threat is used to classify a threat in the ER model.
    Fields are parsed from the exported CSV file 
    Threats have associated consequences, dynamic metrics and a related attack 
    """
    def __init__(self,componentID ,id, name , description, threatSource, likelihood) -> None:
        
        self.id = id                        # The id field in the ER model
        self.componentID = componentID      # The component ID field provided by LucidChart
        self.name = name                   # The name of the component
        
        self.description = description      # The description of the component
        
        self.threatSource = threatSource    # The threat source, source of the threat ...
        self.likelihood = likelihood        # The likelihood of the threat to occur
        
        self.linkedIndicators: dict[int, str] = {}          # Dictironary of linked indicators ID, Reasonnig
    
    def __str__(self) -> str:
        return f"Threat: {self.id}, {self.name}, {self.linkedIndicators}"
    
    def findIndicatorsThreat(df:pd.DataFrame, diagram: component.Diagram, self):
        """
        Links the indicators for the threat to the threat object and updates the metrics dictionary with the indicators
        """         
        
        componentId = self.componentID  # Define the ID of the component
        lines = df.loc[df['Name']=='Line']       # Find all lines in the diagram
        
        lineSource = lines.loc[lines[const.From] == componentId]  # Find the line where the component is the source
        lineDestination = lines.loc[lines[const.To] == componentId]  # ! The component SHOULD be source however, to error handle we need to check for destination as well
                
        if lineSource.isnull().values.any() == True:    # Checks if the threat is the source  or destination
            lineOne = lineSource                
        else:
            lineOne = lineDestination
            
        if lineOne[const.From].item() == componentId:  # If the component is the source
            lineTwo = df.loc[df[const.Id] == lineOne[const.To].item()]  # Find the component associated with the line
        else:
            lineTwo = df.loc[df[const.Id] == lineOne[const.From].item()]  # Find the component associated with the line
            
        
        sourceComponent = df.loc[df[const.Id]==lineTwo[const.From].item()]      # Defines the source of the line connecting threats/consequences and attacks
        destinationComponent = df.loc[df[const.Id]==lineTwo[const.To].item()]   # Defines the destination of the line connecting threats/consequences and attacks
        
    
        if componentType == const.ThreatDynamic:  # * If the component is a threat
            if sourceComponent[const.textArea1].item() == const.Threat:  # Checks if source or destination is the threat
                self.associatedThreat = sourceComponent  
                self.associatedAttack = destinationComponent 
            else:  
                self.associatedThreat = destinationComponent
                self.associatedAttack = sourceComponent
                
        elif componentType == const.ConsequenceDynamic:  # * If the component is a consequence
                        
            if sourceComponent[const.textArea1].item() == const.Consequence:
                self.associatedConsequence = sourceComponent
                self.associatedAttack = destinationComponent
            else:
                self.associatedConsequence = destinationComponent    
                self.associatedAttack = sourceComponent
                
        # ! After parsing the different components related to the dynamics component, 
        # ! the metrics in the component are added to the global metric list and local metric list
        self.linkMetric(df, metricsDict)                  
        
class Consequence: 
    """_summary_
    The class consequence should contain information about a consequence
    Consequences are linked to threats and attacks and also contain their own dynamic metrics
    """
    
    def __init__(self, componentID, id, name, description, consequence) -> None:
        self.id = id                                    # The id field in the ER model
        self.componentID = componentID                  # The component ID field provided by LucidChart
        self.name = name                                # The name of the component
        
        self.description = description                  # The description of the component
        self.consequence = consequence                  # The consequence of the component
        
        self.linkedIndicators: dict[int, str] = {}          # Dictironary of linked indicators ID, Reasonnig

    
    def __str__(self) -> str:
        return f"Consequence: {self.id}, {self.name}, {self.consequence}, {self.linkedIndicators}"
    
    
class Attack: 
    """_summary_
    The class attack should contain information about an attack at the center of the bow tie model 
    Attacks are linked to consequences and threats and contain their own dynamic metrics
    """
    
    def __init__(self, componentID, type, description) -> None:
        self.componentID = componentID                  # The component ID field provided by LucidChart
        
        self.type = type                                # The type of the attack
        self.description = description                  # The description of the component
        
        self.associatedThreats: list[int] = []                     # List of associated threats linked by ID
        self.associatedConsequences: list[int] = []                # List of associated consequences linked by ID
        
    
    def __str__(self) -> str:
        return f"Attack: {self.description}, {self.attackType}"
    
class ERComponent: 
    def __init__(self, name, id, description, type) -> None:
        self.name = name
        self.id = id
        self.description = description
        self.type = type
        self.linkedIndicators:dict[int, str] = {}

    
@dataclass
class Diagram():
    # Dicttionaries of threats, consequences, attacks, indicators and ER components
    threats: dict[int,Threat]                   
    consequences : dict[int,Consequence]
    attacks : dict[int, Attack]             # ! The ID of the attack is the componentID not ID!
    indicators : dict[int, Indicator]
    erComponents : dict[int, ERComponent]
    
    def __init__(self) -> None:
        self.threats = {}
        self.consequences = {}
        self.attacks = {}
        self.dynamics = {}
        self.metrics = {}    
    
    def getThreat(self, id) -> Threat:
        """_summary_

        Args:
            id (_type_): _description_

        Returns:
            Threat: _description_
        """
        
        threat = self.threats[id]
        return threat
   
    def getConsequence(self, id) -> Consequence:
        """_summary_

        Args:
            id (_type_): _description_ 

        Returns:
            Consequence: _description_
        """
        consequence = self.consequences[id]
        return consequence
   
    def getAttack(self, id) -> Attack:
        attack = self.attacks[id]
        return attack

    def getIndicator(self, indicaorID) -> ERDynamic:
        pass