from tkinter import * 
from tkinter import ttk
from tkinter import filedialog
import ERFormatConstants as const
import customtkinter



from components import Diagram
import diagramParser as parse
import dashboardUtils as utils

def openFile():
    fileName = filedialog.askopenfilename(initialdir= "/",
                                          title= "Select lucidchart diagram file",
                                          filetypes=(("CSV Diagram file", "*.csv"),)
    )
    diagram = parse.parseDiagramFile(fileName)    
    
    top = Toplevel(guiRoot)
    top.title("Result Window")
    top.geometry("1600x900")
    
    topFrame = Frame(top)
    topFrame.grid()
    
    canvas = Canvas(topFrame, width=1450, height= 900) # Create Canvas to be able to scroll
    canvas.grid()
    
    # Define scrollbar
    scrollbar = Scrollbar(topFrame, orient="vertical", command=canvas.yview)
    scrollbar.grid(row=0, column=1, sticky="ns")
    
    canvas.configure(yscrollcommand=scrollbar.set)
    canvas.bind(
    '<Configure>', lambda e: canvas.configure(scrollregion=canvas.bbox("all"))
    )
    
    
    canvasFrame = createMetrics(diagram, canvas)
    canvasFrame.grid_columnconfigure(0, weight=1)
    
    canvas.create_window((0,0), window=canvasFrame, anchor="nw")
    
    rowIndex = 0
    
    for threat in diagram.threats.values():
        
        metrics, components = findMetrics(diagram, threat.componentID, "bowtie")
                
        threatFrame = Frame(top)
        threatFrame.grid(row=rowIndex)
        rowIndex +=1

        l1 = Label(threatFrame, text= f"Threat ID: {threat.id} \n Threat description: {threat.threatSource}")
        l2 = Label(threatFrame, text= f"Associated vulnerability: {threat.vulnerability}")        

        listofIndicators = Listbox(threatFrame, font="Helvetica")
        index = 1
        for metric in metrics: 
            listofIndicators.insert(index,metric)
            index +=1
        
        linkedComponents = Listbox(threatFrame, font="Helvetica")
        index = 1
        for component in components:
            linkedComponents.insert(index, component)
            index +=1
            
        l3 = Label(threatFrame, text= f"Observable indicators: {metrics}")


        l4 = Label(threatFrame, text = f"Linked Components: {components}") 
                
        l1.config(font=("Helvetica", 20, "bold"))
        l2.config(font=("Helvetica", 15))
        l3.config(font=("Helvetica", 15))
        l4.config(font=("Helvetica", 15))
        
        l1.grid(row = 4, column = 0)
        l2.grid(row=6, column = 0)
        listofIndicators.grid(row=4, column=10)    
        linkedComponents.grid(row = 4, column = 15)       
                

def tempTestFunction():
    windowWidth = 1250
    windowHeight = 1200
    
    diagram = parse.parseDiagramFile("diagrams/Case1.csv")    
    
    top = Toplevel(guiRoot, bg="blue")
    top.title("Result Window")
    top.geometry("1250x1200")
    top.minsize(windowWidth, windowHeight)
    
    mainFrame = customtkinter.CTkScrollableFrame(top, width=windowWidth, height=windowHeight, bg_color="#155E53")
    mainFrame.grid()
    mainFrame.grid_rowconfigure(0, weight=1)
    
    canvasFrame = createMetrics(diagram, mainFrame, 1550)
    
    
def createMetrics(diagram: Diagram, frame, canvasWidth):
    s = ttk.Style()
    s.theme_use('classic')
    s.configure('Test.TFrame', background='#51D88F',foreground="#1A323B", relief='raised')
    s.configure('Head.TLabel', background='#51D88F', foreground="#1A323B" ,font=('Helvetica', 20, 'bold'))
    s.configure('Test.TLabel', background='#51D88F', foreground="#1A323B" ,font=('Helvetica', 20))
    s.configure('ListFrame.TFrame', background='white', foreground="#155E53")
    s.configure('ListFrame.TLabel', background='white', foreground="#1A323B", font=('Helvetica', 20, 'bold'))
    
    metrics = diagram.metrics.values()
    rowIndex = 0
    
    scoreFrame = ttk.Frame(frame, height=100, width=canvasWidth, padding=10, style='Test.TFrame')
    scoreFrame.grid(padx=10, pady=25, sticky="nsew")
    scoreFrame.grid_columnconfigure(0, weight=1)
    
    headerLabel = ttk.Label(scoreFrame, text="Diagram scorecard", font=("Helvetica", 25, "bold"), style="Head.TLabel")
    label1 = ttk.Label(scoreFrame, text=f"Diagrams parsed! Below is the list of found metrics along with the amount of relationships. Further down you will find the list of metrics with usage and associated components", wraplength=0.5*canvasWidth ,font=("Helvetica", 20), style="Test.TLabel")
    label2 = ttk.Label(scoreFrame, text=f"Number of metrics: {len(diagram.metrics)}", font=("Helvetica", 20), style="Test.TLabel")
    label3 = ttk.Label(scoreFrame, text=f"Number of annotated relationships: {len(diagram.dynamics)}", font=("Helvetica", 20), style="Test.TLabel")
    
    headerLabel.grid(row=0, column=0, sticky="nw")
    label1.grid(row=1, column=0, sticky="nw", pady=10)
    label2.grid(row=2, column=0, sticky="nw")
    label3.grid(row=3, column=0, sticky="nw")
    
    associatedList = {} # Needed to keep track of the number of associated components per metric 

    for metric in metrics:        
        numberOfAssociates = len(metric.bowtieID)+len(metric.erID)
        associatedList[metric.ID] = numberOfAssociates 
    
    rankedList = sorted(associatedList.items(), key=lambda x: x[1], reverse=True)
      
    for i in rankedList:
        amountOFComponents = i[1]
        metricID = i[0]
        metricName = diagram.metrics[metricID].name
        metricValue = diagram.metrics[metricID].value
        metricDate = diagram.metrics[metricID].date
            
        metricFrame = ttk.Frame(frame ,style='Test.TFrame', height= 200, width=canvasWidth, padding=5) # Frame for each metric, should cover 80% of the window and stack vertically
        metricFrame.grid(padx=10, pady=10, sticky="nsew")
        metricFrame.grid_rowconfigure(0, weight=1)
        metricFrame.grid_columnconfigure(0, weight=1)
        
        
        rowIndex +=1 # Increment the row index for the next frame
        ttk.Label(metricFrame, text= f"Metric number: {rowIndex}", style="Head.TLabel").grid(row=0, column=0, sticky="nw")
        
        ttk.Label(metricFrame, text= f"Metric Name: {metricName}", style="Test.TLabel").grid(row=1, column=0, sticky="nw") # First label = Metric id and description
        
        ttk.Label(metricFrame, text= f"Metric value: {metricValue}", style="Test.TLabel", wraplength=0.3*canvasWidth).grid(row=2, column=0, sticky="nw") # First label = Metric id and description

        ttk.Label(metricFrame, text = f"Number of associated components: {amountOFComponents}", style="Test.TLabel").grid(row=1, column=1, sticky="n") # Second label = Number of associated components in both diagrams
        
        ttk.Label (metricFrame, text = f"Last update: {metricDate}", style="Test.TLabel").grid(row=2, column=1, sticky="e") # Third label = Last update of the metric
        
        
        for child in metricFrame.winfo_children():
            child.grid_configure(padx=3, pady=3) 
            
        # Add 2 Frames, one withe Entity relationship components and one with bowtie components
        erFrame = ttk.Frame(metricFrame, style='ListFrame.TFrame', height= 200, width=0.3*canvasWidth, padding=10)
        erFrame.grid(row=3, column=0, sticky="nsew", rowspan=1, padx=10, pady=10)
        ttk.Label(erFrame, text="Entity Relationship components", style="ListFrame.TLabel").grid(row=0, column=0, sticky="nw")
        
        erList = utils.createERLabel(erFrame, diagram.metrics[metricID], diagram)
        for i in range(len(erList)):
            erList[i].grid(row=i+1, column=0, sticky="nw")
        
        bowTieFrame = ttk.Frame(metricFrame, style='ListFrame.TFrame', height= 200, width=0.3*canvasWidth, padding=10)
        bowTieFrame.grid(row=3, column=1, sticky="nsew", rowspan=1, padx=10, pady=10)
        ttk.Label(bowTieFrame, text="BowTie components", style="ListFrame.TLabel").grid(row=0, column=0, sticky="nw")
        
        bowTieList = utils.createBowtieLabel(bowTieFrame, diagram.metrics[metricID], diagram)

        for i in range(len(bowTieList)):
            bowTieList[i].grid(row=i+1, column=0, sticky="nw")
            
    return frame

guiRoot = Tk()

guiRoot.title("Indicator Analyzer for SSC Risk")
guiRoot.geometry("600x300")
label = ttk.Label(guiRoot, text="Welcome to the Indicator Analyzer for SSC Risk", font=("Arial", 20))
label.grid(column=1, row=3)
label2 = ttk.Label(guiRoot, text="Please select CSV export file containing", font=("Arial", 15))
label3 = ttk.Label(guiRoot, text="BowTie risk diagram, Software supply chain architecture diagram and dynamics matrix", font=("Arial", 15))
label2.grid(column=1, row=4)
label3.grid(column=1, row=5)

#labelWindow = Label(guiRoot, text="Please select CSV export file containing ER diagram, BowTie diagram and dynamics matrix", font=("Arial", 20))
#buttonGetFile = Button(guiRoot, text="Select file", command=openFile, width=20, height=2)
#labelWindow.grid(column = 1, row = 1)
#buttonGetFile.grid(column = 1, row = 1)

tempTestFunction()

guiRoot.mainloop()
