from tkinter import * 
from tkinter import ttk
from tkinter import filedialog
import ERFormatConstants as const


from components import *
import diagramParser as parse


def createERLabel(top, metric: Metric, diagram: Diagram):
    s = ttk.Style()
    s.configure('ListFrame.TLabel', background='white', foreground="#1A323B", font=('Helvetica', 15, 'bold'))

    nameList = []
    labelList = []
    for i in metric.erID:
        for j in diagram.dynamics.values():
            if j.type == "ER":
                if i in j.associatedERComponents.keys():
                    if j.associatedERComponents[i] in nameList:
                        pass
                    else: 
                        nameList.append(j.associatedERComponents[i])
                else:
                    pass
    for k in nameList:                    
        label = ttk.Label(top, text= f"{k}", style="ListFrame.TLabel")                
        labelList.append(label)  
    return labelList

def createBowtieLabel(top, metric: Metric, diagram: Diagram):
    s = ttk.Style()
    s.configure('ListFrame.TLabel', background='white', foreground="#1A323B", font=('Helvetica', 15, 'bold'))

    labelList = []
    nameList = []
    
    
    for i in metric.bowtieID:
        if i in diagram.threats.keys():
            label = ttk.Label(top, text= f"Threat component: {diagram.threats[i].description}", style="ListFrame.TLabel")       
            
            nameList.append(diagram.threats[i].description)         
            
            labelList.append(label)
        
        elif i in diagram.consequences.keys():
            label = ttk.Label(top, text= f"Consequence component: {diagram.consequences[i].description}", style="ListFrame.TLabel")      
            
            nameList.append(diagram.consequences[i].description)
                      
            labelList.append(label)
        
        elif i in diagram.attacks.keys():
            label = ttk.Label(top, text= f"Attack component: {diagram.attacks[i].description}", style="ListFrame.TLabel")       
            
            nameList.append(diagram.attacks[i].description)
                     
            labelList.append(label)
            
    return labelList

def findMetrics(diagram, id:int, typeOfObject:str):
    relevantMetrics = []
    relatedComponents = []
    
    for metric in diagram.metrics.values():           
        if typeOfObject == "bowtie":            
            
            if id in metric.bowtieID:
                relevantMetrics.append(metric.name)
                relatedComponents.append(metric.erID)
                
        elif typeOfObject == "er":    
            if id in metric.erID:
                relevantMetrics.append(metric.name)
                relatedComponents.append(metric.bowtieID)
    
    return relevantMetrics, relatedComponents

def createDynamic(diagram: Diagram, top):
    
    for dynamic in diagram.dynamics.values():
        if dynamic.type == "ER":        # If the dynamic is of type ER 
            dynamicDescription = dynamic.description
            entityRelationshipComps = dynamic.associatedERComponents
            label = f"Architecture dynamic, Description: {dynamicDescription}"
            
            textList = []
            
            for i in entityRelationshipComps:
                componentTitle = i[const.textArea1].item()
                componentDescription = i[const.textArea2].item()

                componentLabel1 = Label(top, text= f"Component: {componentTitle}")
                componentLabel1.config(font=("Comic Sans MS", 15))
                componentLabel1.pack()
                
        else:                           # If not it is a bowtie dynamic
            pass
