import pandas as pd 
import ERFormatConstants as const
import components as component
import dynamics as dynamic
import logging as log
import matrices as matrix


# Function will parse a csv file and extract the necessary information, this is step 1 of the parse 
def parseDiagramFile(csvFile) -> component.Diagram: 
    df = pd.read_csv(csvFile)    
    df.drop(["Shape Library", "Page ID", "Contained By", "Group", "Comments", "property 1"], axis=1, inplace=True) #Removing unecessary data
    
    diagram = component.Diagram()   # Defines the diagram object
    
    diagram = matrix.parseTable(df, diagram)            #Parse the table and finds all indicators
    diagram = parseArchitectureDiagram(df, diagram)     #Parse the architecture diagram and finds all ER components along with indicators and reasoning

    diagram = parseThreats(df, diagram)                 # 
    diagram = parseConsequences(df, diagram)    
    diagram = parseAttacks(df, diagram)
           
    
        
    return diagram        
        
# Function will parse the threats and add them to the dictionary    
def parseThreats(df,diagram: component.Diagram):
    for i in range(len(df)):
        if df[const.ThreatComponent][i] == const.Threat: #If the row in the dataframe is a threat
                        
            threat = component.Threat(      
                df[const.Id][i],                # Component ID
                df[const.ThreatIDValue][i],     # ID from ER
                df[const.ThreatName][i],   # Name of the threat
                df[const.ThreatDescription][i], 
                df[const.ThreatSource][i], 
                df[const.Likelihood][i], 
                )
            diagram.threats[df[const.ThreatIDValue][i]] = threat
            
            threat.findIndicatorsThreat(df, diagram, threat) # Find the indicators associated with the threat
            
    return diagram

#Parses consequences and adds it to dictionary 
def parseConsequences(df, diagram: component.Diagram):
    for i in range(len(df)):
        if df[const.ConsequenceComponent][i] == const.Consequence:
                        
            consequence = component.Consequence(
                df[const.Id][i],
                df[const.ConsequenceID][i],
                df[const.ConsequenceName][i],
                df[const.ConsequenceDescription][i],
                df[const.ConsequenceScore][i],
                )
            diagram.consequences[df[const.ConsequenceID][i]] = consequence
            
    return diagram

def parseAttacks(df, diagram: component.Diagram):
    for i in range(len(df)):
        if df[const.AttackComponent][i] == const.Attack:
                        
            attack = component.Attack(
                df[const.Id][i],
                df[const.AttackType][i],
                df[const.AttackDescription][i],
                )
            diagram.attacks[df.Id[i]] = attack #! Note that the ID is the component ID from LucidChart, not my ID
            
    return diagram        

#Parses metrics components and adds it to list
def parseArchitectureDiagram(df, diagram: component.Diagram):
    for i in range(len(df)):     
        # Iterates through the dataframe
        if df[const.textArea1][i] == const.relationship:                    # If the component is a dynamic component
            if df[const.typeField][i] == "ER":                              # * If the component is an ER component                # Find the line where the component is the source
                diagram = parseRelationshipComponentER(df, diagram, i)    
            
    return diagram                    
            
def parseRelationshipComponentER(df: pd.DataFrame, diagram: component.Diagram, row) -> None:
    
    relationshipComponent = df.loc[row] # Define the relationship component
    
    print("Parsing ER component: ", relationshipComponent[const.erName])
    print(relationshipComponent[const.textArea5])
    
    indicatorList = {} # Define a list over relevant indicators to individual relationship component
    erComponents = {} # Define a list over ER components

    #* Iterate over the Relationship component to find all the indicators, and the reasoning for each
    for i in range(len(6 ,relationshipComponent.columns, 2)):
        indicatorID = relationshipComponent[f"Text Area {i}"].item()
        indicatorReason = relationshipComponent[f"Text Area {i+1}"].item()
        indicatorList[indicatorID] = indicatorReason
    
    # * Find all the lines associated with the component
    linesFrom = df.loc[df[const.From] == relationshipComponent[const.Id].item()]  # Find the component associated with the line
    linesTo = df.loc[df[const.To] == relationshipComponent[const.Id].item()]  # Find the component associated with the line
    
    linesFrom.append(linesTo) # Merge the two dataframes
        
    # * Iterate through both lines, and find the ER components related to the relationship component
    for i in range(len(linesFrom)):
        # Defines values
        erName = linesFrom[const.Name][i].item()
        erID = linesFrom[const.erID][i].item()
        erDescription = linesFrom[const.erDescription][i].item()
        erType = linesFrom[const.erType][i].item()
        
        # Create ER component
        erComponent = component.ERComponent(erName,erID, erDescription, erType)
        # Add indicators to the ER component
        erComponent.linkedIndicators.update(indicatorList)
        erComponents[erComponent.id]= erComponent
        
    for i in range (indicatorList):
        indicatorID = i.key()
        # We need to update the indicators with the ER components and the reasoning for the indicator annotation
        diagram.indicators[indicatorID].erAssocaites.update(erComponents)

    return diagram


def extractMetrics(df, index, startRange):
    for j in range(startRange, len(df.columns),2):                   # Parse all text areas to find metrics 
        listOfMetrics = []
        metricID = "Text Area "+str(j)
        metricName = "Text Area "+str(j+1)
        
        if pd.isnull(df[metricID][index]) == False:               # If the text area is not empty
            log.info("Metric: ID", df[metricID][index], "Name: ", df[metricName][index])
            metric = dynamic.Metric(df[metricID][index], df[metricName][index])
            listOfMetrics.append(metric)
        else:
            j=0
            break                                           # First empty field indicates no more metrics
        
        return listOfMetrics                                   # Returns metric found in the dynamic component
        
    
def joinMetrcs(localMetrics: list, globalMetrics: list) -> list:    
    """_summary_
    Function will use a local metric list and insert the local metrics into a global metric list 
    containing all the metrics in the threat landscape
    :param localMetrics: List of metrics from a dynamic component
    :param globalMetrics: List of metrics from the entire threat landscape
    """
    duplicateMetrics = 0                                    # Counter for duplicate metrics per function run
    for i in range(len(globalMetrics)):
        for j in range(len(localMetrics)):
            if globalMetrics[i].name == localMetrics[j].name: # Local metric already exists in the global metric list 
                duplicateMetrics += 1
                break                                         # Check next entry
            else:
                globalMetrics.append(localMetrics[j])       # Add the local metric to the global metric list
                log.info("New local metric added to global metric list, metric: ", localMetrics[j].name)
    log.info("Added all metrics in local list \n, number of duplicate metrics: ", duplicateMetrics, "\n Number of new metrics: ", len(localMetrics)-duplicateMetrics)
    return globalMetrics

