# Requirements for the diagram parser

This document contains the functional and non functional requirements of the application.
Additionally the document contains success criteria which are formulated from the three research questions formulated for the thesis;

- RQ1: What are important aspects of a software supply chain, how do we identify and document them?
- RQ2: What are dynamic aspects of a software supply chain, how do we identify and document them?
- RQ3: How can we maintain traceability and consistency between the software supply chain and its risk picture in a scalable and understandable manner?

## Success criteria

- By leveraging the method and application a developer will be able to identify dynamic indicators related to the found software supply chain threats, and find the different components in the software supply chain architecture related to these dynamic indicators
- The developer will be able to use the resulting scorecard of the modeled software supply chain to identify which dynamic indicators that need to be updated in order to keep maintain an accurate context
- The developer can use the scorecard to assess which components are not accurately represented by the documented indicators.

## Functional requirements

- The developer can leverage a custom library of Entity relationship components in LucidChart to annotate an architecture diagram with dynamic components
- The developer can leverage a custom library of Entity relationship components in LucidChart to annotate create a Bowtie diagram
- The application can parse a lucidChart page containing an architecture model, bowtie model and link matrix through the csv export format
- The parser needs to extract all the information in the diagrams and store it in python classes, including: Threats, Consequences, Attacks, Dynamic componetns, Indicators (Metrics), and Metric matrix
- The application must visualize threats and their related components in the architecture model
- The application must show the linking indicators between, threats, consequences and architecture components
- The application must rank the indicators based on last update to show which indicators are outdated
- The application must rank indicators based on importance, the importance is based on how many components the indicator has an impact on

## Non functional requirements

- The application will feature a user interface to visualize the parsed data
- The application will be able to handle large diagrams with many components to facilitate for scalability
- The application will only accept csv files from lucidchart as input
- The application will be able to run on as a standalone application on a local machine
- The application will only parse the diagrams if the architecture and bowtie diagram have been annotated with the custom library

## Spørsmål til Aida

Hvordan skal jeg definere suksesskriteriene for applikasjonen? Skal jeg definere de først og så tenke på evaluering?

## Thesis problem description

The thesis aims to innovate in the area of risk modeling through the use of bowtie diagrams by facilitating the identification and documentation of dynamic indicators related to software supply chain risk.
The goal of the thesis is to research the possibilitiy of graphical linkage between bow tie risk models and entity relationship diagrams.

This is all in an effort to facilitate dynamic risk management for software supply chains.
The main issue with dynamic risk management is the amount of work related to keeping the risk picture up to date, this can however be done using dynamic indicators which impact the different threats related to software supply chains.

The thesis proposes a method for linking bow tie risk diagrams and entity relationship diagrams through dynamic indicators.
The method will use entity relationship components to annotate bow tie risk models and architecture models with dynamic indicators.
Furthermore the method will use tables for standard indicators and attacks relevant to software supply chains.
Having leveraged the method and its components a developer is left with an updated architecture and bowtie model which contains dynamic indicators, to score the diagrams and provide insight a parser will be developed.
This parser will be able to extract the information from the diagrams and visualize the links between the bowtie model and the system architecture.
The parser will present and score the diagram based on amount of indicators and when they were updated.
Moreover the parser will aid in the identification of which relationships are not accurately represented by the documented indicators.

Method formulation and scorecard developement is being done using Technology research. This methodology splits the research into problem definition where a literature mapping was leveraged to understand state of the art.
The next step is innovation where the method and prototype is developed.

For evaluation the method and tool will be tested on two cases provided by partners.
The tool will be subject to emphirical use case driven evaluation where it is tested on the two cases.
Evaluation will be based on the defined success criteria and requirements for the application.

Preceeding the evaluation a new iteration of technology research will be started to improve the method and tool according to the evaluation.

The focus of the annotation will be on risks and aspects related to software supply chains.
The method will use specialized Entity relationship components to annotate the bow tie risk models and architecture diagram, this annotation will facilitate linkage between an entity relationship diagram of a software supply chain and the bow tie risk models associated with it.
Some examples on success criteria are:

- The developer can use the scorecard to assess which components are not accurately represented by the documented indicators.
- By leveraging the method and application a developer will be able to identify dynamic indicators related to the found software supply chain threats, and find the different components in the software supply chain architecture related to these dynamic indicators

Some examples of the tools functional requirements are:

- The application can parse a lucidChart page containing an architecture model, bowtie model and link matrix through the csv export format
- The parser needs to extract all the information in the diagrams and store it in python classes, including: Threats, Consequences, Attacks, Dynamic componetns, Indicators (Metrics), and Metric matrix
