import ERFormatConstants as const
import logging as log
import components as component


    #Metric class, will be used for all dynamics
class Indicator:
    """
    The metric class is associated with all the dynamics components AND the matrix
    The initial creation of metrics is done through the dynamic units, there the init function is used to create the metrics,
    and fill them with the correct associated components (erID, bowtieID)
    When the object is then accessed again for the matrix parse the metrics are filled with the correct values
    """
    def __init__(self, ID, name, value, date, frequency, guide, scale, interpretation) -> None:
        """
        Metrics are created when parsing dynamics and are there filled with args
        When the matrix is parsed the metrics are filled with the correct values
        Args:
            ID (str): Unique ID for the metric 
            name (str): Unique name for the metric
        """
        #Metrics found in the dynamics tables 
        self.erAssociates: dict[int, component.ERComponent] = {}                # ID of the metric used to locate in dynamics matrics
        self.threatAssoicates: dict[str, component.Threat] = {}            # ID of the metric used to locate in dynamics matrics
        self.consequenceAssociates: dict[str, component.Consequence] = {}  # ID of the metric used to locate in dynamics matrics
        self.attackAssociates: dict[int, component.Attack] = {}            # ID of the metric used to locate in dynamics matrics
        
        
        self.indicatorID = ID                    # ID of the metric used to locate in dynamics matrics
        self.indicatorName = name                # Name of the metric
        self.value = value               # Value of the metric
        self.date = date               # Date of the metric
        self.frequency = frequency           # Frequency of the metric
        self.measureGuide =guide        # Measure guide of the metric
        self.scale = scale              # Scale of the metric
        self.interpretation = interpretation      # Interpretation of the metric
        
        
    def __str__(self) -> str:
        return f"Metric: {self.name}, Value:  {self.value} Last update: {self.date}"
            

        
def linkMetric(self, df, metricsDict: dict):
    """
    Function will extract all the metrics from the dynamics component, add it to the local metric list of the dynamic component,
    the function also adds the metric to the global metric list (if its not already there) and and links the dynamic component to the metric,
    through the associatedER and associatedAttack lists in the metric class 

    Args:
        df (pandas Dataframe): The original dataframe being parsed from lucidchart
        metricsDict (dict): The metricsdict is the global metric list, it contains all the metrics in the diagram
        """
        
    dynamicComponent = df.loc[df[const.Id] == self.componentID]  # Finds the dynamic component we are extracting metrics from
    for i in range (4, len(dynamicComponent.columns), 2): # Iterate through all the metrics
        
        if(dynamicComponent["Text Area "+str(i)].isnull().values.any() == True): # If there are no metrics left
            break                                       # Break the loop
            
        metricID = dynamicComponent["Text Area "+str(i)].item()  # Find the metric ID in the component      
        metricID = int(metricID)
        
        metricName = dynamicComponent["Text Area "+str(i+1)].item()  # Find the metric Name
        
        self.metrics.append(metricID) # ? Adds the metric to the metric list associated with the dynamic component specifically
        
        if checkDuplicateMetrics(metricsDict, metricID) == False: # If the metric is in the global list
            metric = Metric(metricID, metricName)  # Create a new metric object
        else: 
            metric = metricsDict[metricID] # Find the metric
        
        if self.type == const.ThreatDynamic: # If the dynamic component is a threat
            if checkDuplicate(metric.bowtieID, self.associatedThreat[const.Id].item()): #* If the threat component is associated with the metric
                continue # * We wont add it to the metric threatList and attack list since its already there
            metric.bowtieID.append(self.associatedThreat[const.Id].item()) # ? Adds the associated threat to the metric
        
        elif self.type == const.ConsequenceDynamic:  # Same procedure as if above
            if checkDuplicate(metric.bowtieID, self.associatedConsequence[const.Id].item()):
                continue
            metric.bowtieID.append(self.associatedConsequence[const.Id].item())
        
        if checkDuplicate(metric.bowtieID, self.associatedAttack[const.Id].item()): #* If the associated component is a duplicate   
            continue
        metric.bowtieID.append(self.associatedAttack[const.Id].item())
        
        metricsDict[metricID] = metric  # ! Adds the metric to the global metric list
        
class ERDynamic(DynamicComponent):
    """
    The ER dynamic inherits the dynamic component and adds associated ER components
    Contains its own associate function and its own linkMetric function to link metrics
    Has a description and a list of associated ER components 

    Args:
        DynamicComponent (class): parent class
    """
    def __init__(self, componentID, type, description) -> None:
        super().__init__(componentID)
        
        self.description = description    # Description of the dynamic
        self.associatedERComponents = {}   # Associated ER component
        self.type = type 
        
    def __str__(self) -> str:
        return super().__str__() + f"ER Dynamic: {self.type}, {self.description}, Amount of associated components {len(self.associatedERComponents)}"
        
       
    def associatER(self, df, metricsDict: dict):
        """
        Function will associate the ER dynamic with the correct components
        The function will also link the metrics to the ER dynamic component
        The function will also add the metrics to the global metric list
        
        Args:
            df (pandas Dataframe): The original dataframe being parsed from lucidchart
            metricsDict (dict): The metricsdict is the global metric list, it contains all the metrics in the diagram
        """            
        componentId = self.componentID  # Define the ID of the component
        
        #Find the lines associated with the component
        lines = df.loc[df['Name']=='Line']       # Find all lines in the diagram
        relevantLines = []                      # List of lines relevant to the component

        for i in range(len(lines)):            
            line = lines.iloc[i]
            
            if line[const.From] == componentId or line[const.To] == componentId:    # If the line is associated with the component 
                relevantLines.append(lines.iloc[i])   # Add the line to the relevant lines list
        
        for i in range(len(relevantLines)):
            line = relevantLines[i]
            lineSource = line[const.From]   # The source of the line
            lineDestination = line[const.To]
                
            if lineSource == componentId:   # If the line is associated with the component 
                associatedComponentID = lineDestination
            else:
                associatedComponentID = lineSource
            associatedComponent = df.iloc[df.index[df[const.Id] == associatedComponentID]]  # Find the component associated with the line
            associatedComponentRegularID = associatedComponent[const.textArea3].item()  # Find the ID of the associated component
            associatedComponentName = associatedComponent[const.textArea1].item()  # Find the description of the associated component
                        
            self.associatedERComponents[associatedComponentRegularID] = associatedComponentName  # Add the associated component to the list of associated components
        
        self.linkMetric(df, metricsDict) # Link the metrics to the ER dynamic component

    def linkMetric(self,df, metricsDict):
        """
        Links the metrics to the ER dynamic component and adds the metrics to the global metric list

        Args:
            df (Dataframe): The original dataframe being parsed from lucidchart
            metricsDict (dict): The metricsdict is the global metric list, it contains all the metrics in the diagram
        """
        
        dynamicComponent = df.loc[df[const.Id] == self.componentID]  # Find the dynamic component
        
        for i in range (6, len(dynamicComponent.columns), 2): # Iterate through all the metrics 
            
            if(dynamicComponent["Text Area "+str(i)].isnull().values.any() == True): # No more metrics
                break
            
            metricID = dynamicComponent["Text Area "+str(i)].item()  # Find the metric ID   
            metricID = int(metricID)
   
            metricName = dynamicComponent["Text Area "+str(i+1)].item()  # Find the metric ID    
                          
            self.metrics.append(metricID) # ? Adds the metric to the metric list associated with the dynamic component specifically

            if checkDuplicateMetrics(metricsDict, metricID) == False: # If the metric is not a duplicate
                metric = Metric(metricID, metricName)  # Create a new metric object
            else: 
                metric = metricsDict[metricID]
                        
            for i in self.associatedERComponents.keys():
                erID = i
                               
                if checkDuplicate(metric.erID, erID): #* If the associated component is a duplicate
                    continue    
                metric.erID.append(erID)
            metricsDict[metricID] = metric  # ! Adds the metric to the global metric list 
              
def checkDuplicateMetrics(metricsDict: dict, metricID: str):
    """_summary_
    Function will check if the diagrams metric dict contains a metric,
    with the same ID as the one which is listed in the dynamics component, if it does 
    """
    
    if metricID in metricsDict.keys():
        return True
        
    else:
        return False
    
def checkDuplicate(list: list, id: str):
    """_summary_
    Check if the already contains the associated component
    """
    if id in list:    
        return True
    else:
        return False