import pandas as pd
import ERFormatConstants as const
import components as component
import dynamics as dynamic

"""_summary_
Parses csv table and returns a dataframe
This is quite finicky as lucidchart has a very weird way of structuring tables as it is based on when different cells were created
This is quite a big EDGE case and will only work for the specific table shape that I have created
"""
def parseTable(df, diagram: component.Diagram) -> component.Diagram:
    
    cols = [const.Metric_ID, const.Metric_Name, const.Value, const.Measure_date, const.Frequency ,const.Measurement_guide, const.Scale, const.Interpretation]
        
    table = df.loc[df[const.Name]=='Table']    # Defines the table
            
    # ! Prior to parsing the entire table, the first two rows need to be specifically created, 
    # ! This is due to the way the table is structured in LucidChart, the first 6 cells comes first, then the set of standard indicators are next
    # ! Next is the top of the table again with the two rows and 5 columns before new indicators are parsed FCk this shit
    # *  Start table    |  1  |  2  |  3  | 170 | 171 | 172 | 173 | 174 |
    # *  Row 1          |  4  |  5  |  6  | 175 | 176 | 177 | 178 | 179 |
    # *  Row 2          |  7  |  8  |  9  | 180 | 181 | 182 | 183 | 184 |
    # *  Row            . . . . . . . . .. . . . . . . . . . . .. . . . . 
    # *  Row 23         | 162 | 163 | 164 | 165 | 166 | 167 | 168 | 169 | 
    # *  Row 24         | 185 | 186 | 187 | 188 | 189 | 190 | 191 | 191 |
    # *  Etc
    
    
    startStandardIndicators = 21-4   # Column 21-4 
    stopStandardIndicators = 180-4 # First loop needs to stop at column 180-4, 4 columns are removed in diagramParser.py
    interval = len(cols)
    startSpecialIndicators = 196-4 # Text area 185
    stopSpecializedIndicators =  len(table.columns)-2



    indicatorID1 = table[const.textArea4].item()          # Define the Metric ID
    indicatorName1 = table[const.textArea5].item()        # Define the Metric Name
    Value1 = table[const.textArea6].item()            # Define the Value
    MeasureDate1 = table[f"Text Area 175"].item()      # Define the Measure Date
    Frequency1 = table[f"Text Area 176"].item()        # Define the Frequency
    Guide1 = table[f"Text Area 177"].item()            # Define the Measurement guide
    Scale1 = table[f"Text Area 178"].item()
    Interpretation1 = table[f"Text Area 179"].item()
    
    indicatorID1 = int(indicatorID1) # Convert indicator to int
    
    #* Create indicator object
    indicator1 = dynamic.Indicator( 
        indicatorID1,
        indicatorName1,
        Value1,
        MeasureDate1,
        Frequency1,
        Guide1,
        Scale1,
        Interpretation1
    )
    diagram.indicators[indicatorID1] = indicator1 # Insert indicator into diagram dictionary
        
    
    IndicatorID2 = table[const.textArea7].item()          # Define the Metric ID
    IndicatorName2 = table[const.textArea8].item()        # Define the Metric Name
    Value2 = table[const.textArea9].item()            # Define the Value
    MeasureDate2 = table[f"Text Area 180"].item()      # Define the Measure Date
    Frequency2 = table[f"Text Area 181"].item()        # Define the Frequency
    Guide2 = table[f"Text Area 182"].item()            # Define the Measurement guide  
    Scale2 = table[f"Text Area 183"].item()
    Interpretation2 = table[f"Text Area 184"].item()  
    
    IndicatorID2 = int(IndicatorID2)
    
    indicator2 = dynamic.Indicator(
        IndicatorID2,
        IndicatorName2,
        Value2,
        MeasureDate2,
        Frequency2,
        Guide2,
        Scale2,
        Interpretation2
    )
    diagram.indicators[IndicatorID2] = indicator2 # Insert indicator into diagram dictionary
    
    # ! Parsing from the third row and onwards is until row 23, the last row is the standard indicators
    for i in range(startStandardIndicators, stopStandardIndicators, interval):
        if i >= stopStandardIndicators:
            break
        
        IndicatorID = table["Text Area "+str(i)].item()          # Define the Metric ID
        IndicatorName = table["Text Area "+str(i+1)].item()        # Define the Metric Name
        Value = table["Text Area "+str(i+2)].item()             # Define the Value
        MeasureDate = table["Text Area "+str(i+3)].item()       # Define the Measure Date
        Frequency = table["Text Area "+str(i+4)].item()         # Define the Frequency
        Guide = table["Text Area "+str(i+5)].item()            # Define the Measurement guide
                        
        indicator = dynamic.Indicator(
            IndicatorID,
            IndicatorName,
            Value,
            MeasureDate,
            Frequency,
            Guide
        )
        diagram.indicators[IndicatorID] = indicator # Insert indicator into diagram dictionary
                
    # ! Parsing will then continue from the last row, row 24, and onwards with usual text areas for specialized indicators
    for i in range(startSpecialIndicators, stopSpecializedIndicators, interval):
        if i >= stopSpecializedIndicators:
            break
        
        IndicatorID = table["Text Area "+str(i)].item()          # Define the Metric ID
        IndicatorName = table["Text Area "+str(i+1)].item()        # Define the Metric Name
        Value = table["Text Area "+str(i+2)].item()             # Define the Value
        MeasureDate = table["Text Area "+str(i+3)].item()       # Define the Measure Date
        Frequency = table["Text Area "+str(i+4)].item()         # Define the Frequency
        Guide = table["Text Area "+str(i+5)].item()            # Define the Measurement guide
        
        indicator = dynamic.Indicator(
            IndicatorID,
            IndicatorName,
            Value,
            MeasureDate,
            Frequency,
            Guide
        )
        diagram.indicators[IndicatorID] = indicator
            
             
    return diagram