package handelers

import (
	"encoding/json"
	"net/http"
)

// Homepage for the application, handling the main entry point
// without any specific user information provided yet. 
// Contains information on how to use the API, with URLs and examples
func HomeHandler(w http.ResponseWriter, r *http.Request) {
	w.Header().Set(HEADER_CONTENT_TYPE, FORMAT_JSON)
	response := Response{
		WelcomeMessage: WELCOME_MESSAGE,
		Endpoints: map[string]Endpoint{
			INFO_HEADER: {
				Description: INFO_DESCRIPTION + INFO_DESCRIPTION_LIMIT,
				URL: INFO_URL_FORMAT,
				Example: INFO_URL_EXAMPLE,
			},
			STATUS_HEADER : {
				Description : STATUS_DESCRIPTION,
				URL : STATUS_URL,
			},
			POPULATION_HEADER :{
				Description : POPULATION_DESCRIPTION,
				URL : POPULATION_URL,
				Example: POPULATION_URL_EXAMPLE,
			},
		},
	}
	json.NewEncoder(w).Encode(response)
}