package handelers

import (
	"net/http"
	"encoding/json"
	"time"
)

// Function for getting status code from API
func getAPIStatus(url string) (int, error) {
	resp, err := http.Get(url)
	if err != nil {
		return 0, err
	}
	defer resp.Body.Close()
	return resp.StatusCode, nil
}

func DiagnosticsHandler(w http.ResponseWriter, r *http.Request, serviceStartTime time.Time) {
	countriesNowStatus, err1 := getAPIStatus(COUNTRIESNOW_API)
	restCountriesStatus, err2 := getAPIStatus(RESTCOUNTRIES_API)

	if err1 != nil {
		countriesNowStatus = 0
	}
	if err2 != nil {
		restCountriesStatus = 0
	}
	
	response := map[string]any{
		CNA: countriesNowStatus,
		RCA: restCountriesStatus,
		VERSION: VERSJON, 
		UPTIME: getUptime(serviceStartTime) , 
	}

	w.Header().Set(FORMAT_JSON, FORMAT_JSON)
	formattedResponse, _ := json.MarshalIndent(response, "", "  ")
	w.Write(formattedResponse)
}

func getUptime(serviceStartTime time.Time) int64 {
	return int64(time.Since(serviceStartTime).Seconds())
}