# Assignment 1

## Kjøre koden  
Koden kjøres ved å skrive følgende kommando i terminalen:  

```sh
go run main.go
```

Når serveren starter, kan du åpne nettleseren og navigere til:
* http://localhost:8080/ 
    - Dette er hjemmesiden til API-et.
    - Når serveren startes er det hit du eventuelt blir sendt automatisk
* Alternativt kan du bruke en av endepunktene beskrevet nedenfor for å navigere applikasjonen


## Hjemmeside (/)
Når du åpner API-et uten spesifikke forespørsler (http://localhost:8080/), vil du få en JSON-respons med informasjon om hvordan du bruker API-et.

Her får du informasjon om de tre tilgjengelige endepunktene:
1. info - Henter generell informajson om et land.
2. populasjon - Henter populasjonsdata for et land.
3. status - Viser status for API-et.

I tillegg vises eksempler på hvordan du kan sende forespørsler til de ulike endepunktene.

## Endepunkter
### info
Henter informasjon om et land basert på en 2-bokstavs landkode (ISO 3166-2).

```sh
http://localhost:8080/countryinfo/v1/info/{country_code}{?limit=10}
```
* Metode: GET
* Eksempel: http://localhost:8080/countryinfo/v1/info/NO?limit=4

#### populasjon
Hente populasjonsdata om et land basert på en 2-bokstavs landkode (ISO 3166-2).

```sh
http://localhost:8080/countryinfo/v1/population/{country_code}{?startyear-endYear}
```
* Metode: GET
* Eksempel: http://localhost:8080/population/NO?limit=2010-2015

### status
Viser status for de eksterne API-ene, versjon og applikasjonens oppetid.

 ```sh
http://localhost:8080/countryinfo/v1/status
```
        


