package handelers
import (
	"encoding/json"
	"net/http"
)

// hjemmeside for kjøring av applikasjonen som sender deg direkte til en side uten spesifiksejoner gitt
// av brukeren.
//INFO
func HomeHandler(w http.ResponseWriter, r *http.Request) {
	w.Header().Set("Content-Type", "application/json")
	response := map[string]interface{}{
		"WELCOME": "Welcome to the Country Info API",
		"endpoints": map[string]interface{}{
			"Get Country Info": map[string]string{
				"Description": "Get country details including cities, population, and more.",
				"URL Format":         "http://localhost:8080/countryinfo/v1/info/{country_code}{?limit=10}",
				"Example":     "http://localhost:8080/countryinfo/v1/info/NO?cities=5",
			},
			"Get status info" : map[string]string{
				"Description" : "Get information about the API statuses",
				"URL" : "http://localhost:8080/status/",
			},
		},
	}

	json.NewEncoder(w).Encode(response)
}