package handelers

import (
	"net/http"
	"fmt"
	"encoding/json"
	"time"
)




// Funksjon for å hente statuskode fra et API
func getAPIStatus(url string) (int, error) {
	resp, err := http.Get(url)
	if err != nil {
		return 0, err
	}
	defer resp.Body.Close()

	// Returner HTTP-statuskoden
	return resp.StatusCode, nil
}



// Handler for Diagnostics endpoint
func DiagnosticsHandler(w http.ResponseWriter, r *http.Request, serviceStartTime time.Time) {
	// Hent statuskoder fra eksterne API-er
	countriesNowStatus, err := getAPIStatus("http://129.241.150.113:3500/api/v0.1/countries")
	if err != nil {
		http.Error(w, "Error fetching CountriesNow status", http.StatusInternalServerError)
		return
	}

	restCountriesStatus, err := getAPIStatus("http://129.241.150.113:8080/v3.1/all") //funker med all
	if err != nil {
		http.Error(w, "Error fetching RestCountries status", http.StatusInternalServerError)
		return
	}

	// Bygg responsen med statusinformasjon
	response := map[string]interface{}{
		"countriesnowapi": fmt.Sprintf("%d", countriesNowStatus),
		"restcountriesapi": fmt.Sprintf("%d", restCountriesStatus),
		"version":          "v1", // Versjon av API
		"uptime":           getUptime(serviceStartTime), // Oppetid i sekunder
	}

	// Sett Content-Type til application/json
	w.Header().Set("Content-Type", "application/json")
	
	// Returner JSON-responsen
	json.NewEncoder(w).Encode(response)
}

// Funksjon for å beregne oppetid
func getUptime(serviceStartTime time.Time) int64 {
	return int64(time.Since(serviceStartTime).Seconds()) // Bruk serviceStartTime fra parameter
}